;
; *** Listing 10-11 ***
;
; Clears a 1000-byte block of memory via BlockClear,
; which handles blocks between 0 and 64K-1 bytes in
; length.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
ByteArray	db	ARRAY_LENGTH dup (?)
;
; Clears a block of memory CX bytes in length. A value
; of 0 means "clear zero bytes," so the maximum length
; that can be cleared is 64K-1 bytes and the minimum
; length is 0 bytes.
;
; Input:
;	CX = number of bytes to clear
;	ES:DI = start of block to clear
;
; Output:
;	none
;
; Registers altered: AL, CX, DI
;
; Direction flag cleared
;
BlockClear:
	sub	al,al	;fill with zero
	cld		;make STOSB move DI up
	rep	stosb	;clear the block
	ret
;
Skip:
	call	ZTimerOn
	mov	di,seg ByteArray
	mov	es,di	;point ES:DI to the array to clear
	mov	di,offset ByteArray
	mov	cx,ARRAY_LENGTH	;# of bytes to clear
	call	BlockClear	;clear the array
	call	ZTimerOff
