;
; *** Listing 7-14 ***
;
; Performs bit-doubling of a byte in AL to a word in AX
; by using doubled shifts, one from each of two source
; registers. This approach avoids branching and is very
; fast according to official instruction timings, but is
; actually quite slow due to instruction prefetching.
;
; (Based on an approach used in "Optimizing for Speed,"
; by Michael Hoyt, Programmer's Journal 4.2, March, 1986.)
;
; Macro to double each bit in a byte.
;
; Input:
;	AL = byte to bit-double
;
; Output:
;	AX = bit-doubled word
;
; Registers altered: AX, BX
;
DOUBLE_BYTE	macro
	mov	ah,al	;put the byte to double in two
			; registers
	mov	bx,ax
	rept	8
	shr	bl,1	;get the next bit to double
	rcr	ax,1	;move it into the msb...
	shr	bh,1	;...then get the bit again...
	rcr	ax,1	;...and replicate it
	endm
	endm
;
	call	ZTimerOn
BYTE_TO_DOUBLE=0
	rept	100
	mov	al,BYTE_TO_DOUBLE
	DOUBLE_BYTE
BYTE_TO_DOUBLE=BYTE_TO_DOUBLE+1
	endm
	call	ZTimerOff
