;
; *** Listing 7-8 ***
;
; Strips the high bit of every byte in a byte-sized array
; without using a segment override prefix.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
TestArray	db	ARRAY_LENGTH dup (0ffh)
;
; Strips the high bit of every byte in a byte-sized array.
;
; Input:
;	CX = length of array
;	ES:BX = pointer to start of array
;
; Output: none
;
; Registers altered: AL, BX
;
StripHighBits	proc	near
	push	ds		;save normal DS
	mov	ax,es		;point DS to the array's
	mov	ds,ax		; segment
	mov	al,not 80h	;bit pattern for stripping
				; high bits, loaded into a
				; register outside the loop
				; so we can use fast
				; register-to-memory ANDing
				; inside the loop
StripHighBitsLoop:
	and	[bx],al		;strip this byte's high bit
	inc	bx		;point to next byte 
	loop	StripHighBitsLoop
	pop	ds		;restore normal DS
	ret
StripHighBits	endp
;
Skip:
	call	ZTimerOn
	mov	bx,seg TestArray
	mov	es,bx
	mov	bx,offset TestArray	;point to array
					; which will have
					; high bits stripped
	call	StripHighBits		;strip the high bits
	call	ZTimerOff
