;
; *** Listing 11-10 ***
;
; Counts the number of times the letter 'A'
; appears in a byte-sized array, using REPNZ SCASB.
;
	jmp	Skip
;
ByteArray	label	byte
	db	'ARRAY CONTAINING THE LETTER ''A'' 4 TIMES'
ARRAY_LENGTH	equ	($-ByteArray)
;
; Counts the number of occurrences of the specified byte
; in the specified byte-sized array.
;
; Input:
;	AL = byte of which to count occurrences
;	CX = array length (0 means 64K)
;	DS:DI = array to count byte occurrences in
;
; Output:
;	DX = number of occurrences of the specified byte
;
; Registers altered: CX, DX, DI, ES
;
; Direction flag cleared
;
; Note: Does not handle arrays that are longer than 64K
;	bytes or cross segment boundaries. Does not handle
;	overlapping strings.
;
ByteCount:
	push	ds
	pop	es		;SCAS uses ES:DI
	sub	dx,dx		;set occurrence counter to 0
	cld
	and	cx,cx		;64K long?
	jnz	ByteCountLoop	;no
	dec	cx		;yes, so handle first byte
				; specially, since JCXZ will
				; otherwise conclude that
				; we're done right away
	scasb			;is first byte a match?
	jz	ByteCountCountOccurrence
				;yes, so count it
ByteCountLoop:
	jcxz	ByteCountDone	;if there's nothing left to
				; search, we're done
	repnz	scasb		;search for the next byte
				; occurrence or the end of
				; the array
	jnz	ByteCountDone	;no match
ByteCountCountOccurrence:
	inc	dx		;count this occurrence
	jmp	ByteCountLoop	;check the next byte, if any
ByteCountDone:
	ret
;
Skip:
	call	ZTimerOn
	mov	al,'A'		;byte of which we want a
				; count of occurrences
	mov	di,offset ByteArray
				;array we want a count for
	mov	cx,ARRAY_LENGTH	;# of bytes to check
	call	ByteCount	;get the count
	call	ZTimerOff
