;
; *** Listing 11-15 ***
;
; Finds the last non-blank character in a string, using
; LODSW and checking 2 bytes per read.
;
	jmp	Skip
;
TestString	label	byte
	db	'This is a test string with blanks....'
	db	'                                     ',0
;
; Finds the last non-blank character in the specified
; zero-terminated string.
;
; Input:
;	DS:SI = zero-terminated string to search
;
; Output:
;	SI = pointer to last non-blank character in string,
;		or 0 if there are no non-blank characters in
;		the string
;
; Registers altered: AX, BL, DX, SI
;
; Direction flag cleared
;
; Note: Do not pass a string that starts at offset 0 (SI=0),
;	since a return pointer to the first byte and failure
;	to find a non-blank character would be
;	indistinguishable.
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
FindLastNonBlankInString:
	mov	dx,1	;so far we haven't found a non-blank
			; character
	mov	bl,' '	;put our search character, the space
			; character, in a register for speed
	cld
FindLastNonBlankInStringLoop:
	lodsw		;get the next 2 string bytes
	and	al,al	;is the first byte the terminating
			; zero?
	jz	FindLastNonBlankInStringDone
			;yes, we're done
	cmp	al,bl	;is the second byte a space?
	jz	FindLastNonBlankInStringNextChar
			;yes, so check the next character
	mov	dx,si	;remember where the non-blank was
	dec	dx	;adjust back to first byte of word
FindLastNonBlankInStringNextChar:
	and	ah,ah	;is the second byte the terminating
			; zero?
	jz	FindLastNonBlankInStringDone
			;yes, we're done
	cmp	ah,bl	;is the second byte a space?
	jz	FindLastNonBlankInStringLoop
			;yes, so check the next 2 bytes
	mov	dx,si	;remember where the non-blank was
	jmp	FindLastNonBlankInStringLoop
			;check the next 2 bytes
FindLastNonBlankInStringDone:
	dec	dx	;point back to the last non-blank
			; character, correcting for the
			; 1-byte overrun of LODSW
	mov	si,dx	;return pointer to last non-blank
			; character in SI
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset TestString 	;string to search
	call	FindLastNonBlankInString ;search for the byte
	call	ZTimerOff
