;
; *** Listing 11-2 ***
;
; Copies a string to another string, converting all
; characters to uppercase in the process, using a loop
; containing non-string instructions.
;
	jmp	Skip
;
SourceString	label	word
	db	'This space intentionally left not blank',0
DestString	db	100 dup (?)
;
; Copies one zero-terminated string to another string,
; converting all characters to uppercase.
;
; Input:
;	DS:SI = start of source string
;	ES:DI = start of destination string
;
; Output:
;	none
;
; Registers altered: AL, BX, SI, DI
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
CopyStringUpper:
	mov	bl,'a'	;set up for fast register-register
	mov	bh,'z'	; comparisons
StringUpperLoop:
	mov	al,[si]	;get the next character
	inc	si	;point to the following character
	cmp	al,bl	;below 'a'?
	jb	IsUpper	;yes, not lowercase
	cmp	al,bh	;above 'z'?
	ja	IsUpper	;yes, not lowercase
	and	al,not 20h ;is lowercase-make uppercase
IsUpper:
	mov	es:[di],al ;put the uppercase character into
			; the new string
	inc	di	;point to the following character
	and	al,al	;is this the zero that marks the
			; end of the string?
	jnz	StringUpperLoop ;no, do the next character
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset SourceString	;point DS:SI to the
					; string to copy from
	mov	di,seg DestString
	mov	es,di			;point ES:DI to the
	mov	di,offset DestString	; string to copy to
	call	CopyStringUpper		;copy & convert to
					; uppercase
	call	ZTimerOff
