/*************************************************************************

	dr_ibmpc.c      Directory (dr) subroutines
			for Bywater Software.

			Implementation for the IBM PC (tm)
			and compatible microcomputers
			utilizing Microsoft QuickC (tm)

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "stdio.h"
#include "dos.h"
#include "sys\types.h"
#include "sys\stat.h"
#include "dr.h"

int     dr_fs = '\\';
char    dr_all[ MAX_PATHLENGTH ] = "*.*";

static struct   find_t myfind;
static char      _path[ MAX_PATHLENGTH ];

dr_first( findb, retb )
	char findb[];
	struct dir_ent *retb;
	{
	register int c;

	if ( _dos_findfirst( findb, _A_NORMAL | _A_SUBDIR, &myfind ) == 0 )
		{
		strcpy( retb->filename, myfind.name );
		strcpy( _path, findb );

		c = strlen( _path );
		while (( c >= 0 ) && ( _path[ c ] != dr_fs ))
			{
#ifdef  OLD_DEBUG
			fprintf( stderr, "_path: %s \n", _path );
#endif
			_path[ c ] = 0;
			--c;
			}

		strcpy( retb->pathname, _path );

		fill_buffer( retb );
		return 1;
		}
	else
		{
		return 0;
		}
	}

dr_next( retb )
	struct dir_ent *retb;
	{
	if ( _dos_findnext( &myfind ) == 0 )
		{
		strcpy( retb->filename, myfind.name );
		strcpy( retb->pathname, _path );
		fill_buffer( retb );
		return 1;
		}
	else
		{
		return 0;
		}
	}


fill_buffer( retb )
	struct dir_ent *retb;
	{
	static struct stat s_buf;
	static char newpath[ MAX_PATHLENGTH ];

	if ( strlen( _path ) > 0  )
		{
		sprintf( newpath, "%s%s", _path, retb->filename );
		}
	else
		{
		strcpy( newpath, retb->filename );
		}

	if ( stat( newpath, &s_buf ) < 0 )
		{
#ifdef  DEBUG
		fprintf( stderr, "stat() to %s failed. \n", newpath );
#endif
		}

	retb->size = s_buf.st_size;

	if ( ibm_isexec( retb ) == TRUE )
		{
		retb->type = FILE_EXECUTABLE;
		}

	else if ( ( s_buf.st_mode & S_IFDIR ) == S_IFDIR )
		{
		retb->type = FILE_DIRECTORY;
		}

	else
		{
		retb->type = FILE_NORMAL;
		}

	return TRUE;

	}

ibm_isexec( retb )
	struct dir_ent *retb;
	{
	static char buffer[ MAX_PATHLENGTH ];
	register int c, d;

	if ( strlen( retb->filename ) < 5 )
		{
		return FALSE;
		}

	d = 0;
	for ( c = strlen( retb->filename ) - 4;
		c < strlen( retb->filename ); ++c )
		{
		buffer[ d ] = retb->filename[ c ];
		++d;
		buffer[ d ] = 0;
		}

	if ( strcmp( buffer, ".EXE" ) == 0 )
		{
		return TRUE;
		}
	else if ( strcmp( buffer, ".COM" ) == 0 )
		{
		return TRUE;
		}
	else if ( strcmp( buffer, ".BAT" ) == 0 )
		{
		return TRUE;
		}
	else
		{
		return FALSE;
		}
	}
