/*************************************************************************

	dr_test.c       Directory (dr) subroutines
			for Bywater Software.

			Test program

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "stdio.h"
#ifdef	__STDC__
#include "malloc.h"
#else
extern	char *malloc();
#endif
#include "dr.h"

#define	DIR_ENTRIES	128

char findname[ MAX_PATHLENGTH ];
struct dir_ent *retstructs[ DIR_ENTRIES ];

main()
	{
	register int c;

	for ( c = 0; c < DIR_ENTRIES; ++c )
		{
		if ( ( retstructs[ c ] 
			= (struct dir_ent *) malloc( sizeof( struct dir_ent )) ) == NULL )
			{
			fprintf( stderr, "Failed to allocate memory for directory structure.\n" );
			exit( 1 );
			}
		}

	printf( "Enter an ambiguous file specifier:  " );
	gets( findname );
/*	printf( "\n" ); */

	c = 0;
	if ( dr_first( findname, retstructs[ c ] ) == 0 )
		{
		printf( "No matches found.\n" );
		exit( 1 );
		}


	printf( "Pathname: %s\tFilename: %s\tType: %d\tSize: %ld\n",
		retstructs[ c ]->pathname,
		retstructs[ c ]->filename,
		retstructs[ c ]->type,
		retstructs[ c ]->size );
	++c; 

	while( dr_next( retstructs[ c ] ) != 0 )
		{
		printf( "Pathname: %s\tFilename: %s\tType: %d\tSize: %ld\n",
			retstructs[ c ]->pathname,
			retstructs[ c ]->filename,
			retstructs[ c ]->type,
			retstructs[ c ]->size );
		++c;
		}
	}


