/****************************************************************

	gr.h		Header for Graphics Interface 
			for Bywater Software

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

extern int	gr_screens;
extern int	gr_colors;
extern int	gr_pxsize;
extern int	gr_pysize;
extern int	gr_ismouse;
extern int      gr_clipping;
extern int      gr_blitting;
extern int      gr_saving;

/****************************************************************

	boolean operators

****************************************************************/

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

/****************************************************************

	boolean operators

****************************************************************/

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

/****************************************************************

	colors

****************************************************************/

#define BLACK           0
#define WHITE           1
#define LIGHT_RED       2
#define LIGHT_GREEN     3
#define LIGHT_BLUE      4
#define LIGHT_YELLOW    5
#define LIGHT_CYAN      6
#define LIGHT_MAGENTA   7
#define DARK_RED        10
#define DARK_GREEN      11
#define DARK_BLUE       12
#define DARK_YELLOW     13
#define DARK_CYAN       14
#define DARK_MAGENTA    15

/****************************************************************

	fill (and line) styles

****************************************************************/

#define HOLLOW          0		/* Hollow fill -- draw perimeter */
#define SOLID           1
#define GRID            2
#define HATCH           3

/****************************************************************

	input modes

****************************************************************/

#define	STATUS	0
#define	WAIT	1
#define	SAMPLE	2
#define HIDE    3
#define SHOW    4
#define POSITION        5

/****************************************************************

	figure drawing modes

****************************************************************/

#define PERIMETER       1
#define FILL            2

/****************************************************************

	screens

****************************************************************/

#define GR_PRIMARY	0	/* primary drawing screen */
#define GR_HIDDEN	1	/* secondary or hidden drawing screen */

/****************************************************************

	fonts

****************************************************************/

#define F_DEFAULT       0
#define F_ROMAN         1
#define F_GOTHIC        2
#define F_ITALIC        3

/****************************************************************

	gr_window structure

****************************************************************/

struct gr_window
	{
	int initialized;        /* Boolean:  successfully initialized?  */
	int xmax;               /* Maximum number of pixels, x axis     */
	int ymax;               /* Maximum number of pixels, y axis     */
	int font;		/* Current font style 			*/
	int fxsize;             /* Font size in pixels, x axis          */
	int fysize;             /* Font size in pixels, y axis          */
	int clipping;           /* Boolean:  is cliiping in use?        */
	int cl_x1;              /* Left of clip window                  */
	int cl_y1;              /* Bottom of clip window                */
	int cl_x2;              /* Right of clip window                 */
	int cl_y2;              /* Top of clip window                   */
	};

extern long gr_imsize();
extern unsigned int gr_strlen();
