/*************************************************************************

	kb_spec.c	Keyboard (KB) Subroutines
			for Bywater Software

			Specification for developing new implementations.

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "kb.h"

/*************************************************************************

	FUNCTION:       kb_init()

	DESCRIPTION:    This function should perform any initialization
			necessary for the keyboard system.

	INPUT:          none.

	RETURNS:        none.

**************************************************************************/

kb_init()
	{
	}

/*************************************************************************

	FUNCTION:       kb_deinit()

	DESCRIPTION:    This function should perform any necessary
			deinitialization, that is, return the keyboard
			to its default state when a Simple Software
			program is to be exited.

	INPUT:          none.

	RETURNS:        none.

**************************************************************************/

kb_deinit()
	{
	}

/*************************************************************************

	FUNCTION:       kb_rxstat()

	DESCRIPTION:    This function determines whether a character is
			ready from the console.  The function is used
			especially in telecommunications programs,
			where it is necessary to poll the keyboard
			without locking up the program waiting for a
			response.

	INPUT:          none.

	RETURNS:        The function returns FALSE if no character is
			available and TRUE if a character is available.

**************************************************************************/

kb_rxstat()
     {
     }

/*************************************************************************

	FUNCTION:       kb_rx()

	DESCRIPTION:    This function returns a single character from
			the keyboard.  If a character is not available
			it waits.  The function should be able to
			recognize any special keys, and return the
			appropriate KB conventions designated for
			them in "kb.h".

	INPUT:          none.

	RETURNS:        The function returns the ASCII code for the
			key pressed, or the Simple Software KB convention
			(see kb.h) for a function or other special key.

**************************************************************************/

kb_rx()
     {
     }

