/****************************************************************

	tw_ibmpc.c      Graphics Text Window
			for IBM PC (tm) and compatibles
			utilizing Microsoft QuickC (tm)

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023
			Duke Station
			Durham, NC  27706

			email: tcamp@teer3.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not
	be used for illegal activities.

****************************************************************/

#include "stdio.h"

#include "graph.h"

#ifdef __STDC__
#include "malloc.h"
#else
extern char * malloc();
#endif

#include "bw.h"
#include "gr.h"
#include "tw.h"

#define DEF_LINES       25
#define DEF_COLUMNS     80

static struct tw_struct * cur_twstruct = NULL;

struct tw_struct *
tw_init( rq_x1, rq_y2, rq_lines, rq_cols, min_x1, min_y1, max_x2, max_y2 )
   int rq_x1;                   /* requested x1 (left, graphics) position */
   int rq_y2;                   /* requested y2 (top,  graphics) position */
   int rq_lines;                /* requested text lines */
   int rq_cols;                 /* requested text columns */
   int min_x1;                  /* leftmost   allowable position */
   int min_y1;                  /* bottommost allowable position */
   int max_x2;                  /* rightmost  allowable position */
   int max_y2;                  /* topmost    allowable position */
   {
   static struct videoconfig ibm_vc;
   struct tw_struct *tw;
   int x, y;

   /* get memory for tw_struct structure */

   if ( ( tw = (struct tw_struct *) malloc( sizeof( struct tw_struct ))) == NULL )
      {
      bw_error( "Failed to find memory for window." );
      return NULL;
      }

   /* determine current size of screen and then text fonts */

   _getvideoconfig( &ibm_vc );
   tw->fxsize = ibm_vc.numxpixels / DEF_COLUMNS;
   if ( ibm_vc.mode == _HERCMONO )
      {
      tw->fysize = ( ibm_vc.numypixels + 2 ) / DEF_LINES;
      }
   else
      {
      tw->fysize = ibm_vc.numypixels / DEF_LINES;
      }

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "fxsize: %d, fysize: %d",
      tw->fxsize, tw->fysize );
   bw_debug( bw_ebuf );
#endif

   /* calculate optimum x1 (left) position for window */

   if ( abs( rq_x1 -   ( abs( rq_x1 / tw->fxsize ) * tw->fxsize ) ) >
	abs( rq_x1 - ( ( abs( rq_x1 / tw->fxsize ) * tw->fxsize ) + tw->fxsize )) )
	{
	tw->x1 = ( ( abs ( rq_x1 / tw->fxsize ) * tw->fxsize ) + tw->fxsize );
	}
   else
	{
	tw->x1 = abs( rq_x1 / tw->fxsize ) * tw->fxsize;
	}

   /* be sure it is in bounds */

   if ( tw->x1 < min_x1 )
      {
      tw->x1 += tw->fxsize;
      }

   /* calculate optimum y (top) position for window */

   if ( abs( rq_y2 -   ( abs( rq_y2 / tw->fysize ) * tw->fysize ) ) >
	abs( rq_y2 - ( ( abs( rq_y2 / tw->fysize ) * tw->fysize ) + tw->fysize )) )
	{
	tw->y2 = ( ( abs ( rq_y2 / tw->fysize ) * tw->fysize ) + tw->fysize );
	}
   else
	{
	tw->y2 = ( abs ( rq_y2 / tw->fysize ) * tw->fysize );
	}

   /* be sure it is in bounds */

   if ( tw->y2 > max_y2 )
      {
      tw->y2 -= tw->fxsize;
      }

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "x position: %d, y position: %d",
      tw->x1, tw->y2 );
   bw_debug( bw_ebuf );
#endif

   /* calculate requested right screen position */

   tw->x2 = tw->x1 + ( rq_cols * tw->fxsize );

   /* back up to an acceptable position */

   while ( tw->x2 > max_x2 )
      {
      tw->x2 -= tw->fxsize;
      }

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "right position (x2): %d [max_x2 is %d] ",
      tw->x2, max_x2 );
   bw_debug( bw_ebuf );
#endif

   /* now set number of text columns based on this */

   tw->columns = ( tw->x2 - tw->x1 ) / tw->fxsize;

   /* calculate requested bottom screen position */

   tw->y1 = tw->y2 - ( rq_lines * tw->fysize );

   /* back up to an acceptable position */

   while ( tw->y1 < min_y1 )
      {
      tw->y1 += tw->fysize;
      }

   /* now set number of text lines based on this */

   tw->lines = ( tw->y2 - tw->y1 ) / tw->fysize;

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "Lines: %d    Columns %d",
      tw->lines, tw->columns );
   bw_debug( bw_ebuf );
   sprintf( bw_ebuf, "x1 %d, y1 %d, x2 %d, y2 %d",
      tw->x1, tw->y1, tw->x2, tw->y2 );
   bw_debug( bw_ebuf );
   sprintf( bw_ebuf, "set text window: y2 %d, x1 %d, y1 %d, x2 %d",
		   DEF_LINES - ( tw->y2 / tw->fysize ) + 1,
		   ( tw->x1 / tw->fxsize ) + 1,
		   ( DEF_LINES - ( tw->y1 / tw->fysize ) ),
		   ( ( tw->x2 / tw->fxsize ) - 1 ));
   bw_debug( bw_ebuf );
#endif

   /* set text window */

   _settextwindow(
		   DEF_LINES - ( tw->y2 / tw->fysize ) + 1,
		   ( tw->x1 / tw->fxsize ) + 1,
		   ( DEF_LINES - ( tw->y1 / tw->fysize ) ),
		   ( ( tw->x2 / tw->fxsize ) - 1 ));

   _wrapon( _GWRAPOFF );

   cur_twstruct = tw;

   return tw;

   }

tw_deinit( tw )
   struct tw_struct *tw;
   {
   free( tw );
   }

tw_outc( c )
   int c;
   {
   char s[ 2 ];

   msm_hide();

   s[ 0 ] = c;
   s[ 1 ] = 0;
   _outtext( s );

   msm_show();

   }

tw_outs( s, line, column, color )
   char *s;
   int line, column, color;
   {

   msm_hide();

   _settextposition( line + 1, column + 1 );
   _settextcolor( ibm_color( color ) );
   _outtext( s );

   msm_show();

   }

tw_adr( line, column )
   int line, column;
   {

   msm_hide();
   _settextposition( line + 1, column + 1 );
   msm_show();
   }

tw_cursor( action )
  int action;
  {
  if ( action == TRUE )
     {
     _settextcursor( (short) 0x0607 );
     _displaycursor( _GCURSORON );
     }
  else
     {
     _settextcursor( (short) 0x2000 );
     _displaycursor( _GCURSOROFF );
     }
  }

tw_cleol( line, column )
   int line, column;
   {
   int x1, y2;

   x1 = cur_twstruct->x1 + ( column * cur_twstruct->fxsize );
   y2 = cur_twstruct->y2 - ( line * cur_twstruct->fysize );
   gr_rectangle( GR_PRIMARY, x1, y2 - ( cur_twstruct->fysize - 1 ),
      cur_twstruct->x2, y2, BLACK, SOLID );

   }
