/****************************************************************

	ui_boxes.c      Box drawing and window routines for
			The Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023
			Duke Station
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not
	be used for illegal activities.

****************************************************************/

#include "stdio.h"
#include "bw.h"
#include "gr.h"
#include "ui.h"

#ifdef 	__STDC__
#include "malloc.h"
#else
extern  char * malloc();
#endif

struct uiwindow *
ui_window( x1, y1, x2, y2, t_flag, t_bcolor, t_tcolor, t_text,
   b_flag, b_color,
   s_flag, s_color, m_color, m_style, buttons )
   int x1, y1, x2, y2;          /* coordinates of whole area    */
   int t_flag;                  /* title flag         */
   int t_bcolor, t_tcolor;      /* title background & text colors */
   char *t_text;                /* text of title      */
   int b_flag, b_color;         /* border flag, color      */
   int s_flag, s_color;         /* shadow flag, color      */
   int m_color, m_style;        /* color & style for main box   */
   int buttons;                 /* buttons */
   {
   static int _x1, _y1, _x2, _y2;  /* counters for coordinates     */
   static struct uiwindow *ret_struct;     /* structure for return data    */
   int s_ysize;

   if ( ui_ready == 0 )
      {
#ifdef DEBUG
      bw_error( "The ui system is not initialized." );
#endif
      return;
      }

   /* Get memory for window structure */

   if ( ( ret_struct = (struct uiwindow *) malloc( sizeof( struct uiwindow ) )) == 0 )
      {
      bw_error( "Cannot allocate storage for window data." );
      return;
      }

   /* Initialize counters */

   ret_struct->x1 = _x1 = x1;
   ret_struct->y1 = _y1 = y1;
   ret_struct->x2 = _x2 = x2;
   ret_struct->y2 = _y2 = y2;
   ret_struct->t_flag = t_flag;
   ret_struct->t_bcolor = t_bcolor;
   ret_struct->t_tcolor = t_tcolor;
   ret_struct->s_flag = s_flag;
   ret_struct->s_color = s_color;
   ret_struct->b_flag = b_flag;
   ret_struct->b_color = b_color;
   ret_struct->m_color = m_color;
   ret_struct->m_style = m_style;

   /* display the shadow */

   if ( s_flag == TRUE )
      {
      s_ysize = (SHADOW_XSIZE * gr_pxsize ) / gr_pysize;
      ui_fbox( x1 + SHADOW_XSIZE, y1, x2, y2 - s_ysize,
	 s_color, SOLID );
      _y1 += s_ysize;
      _x2 -= SHADOW_XSIZE;
      }

   /* draw a one-pixel black line around the whole area */

   gr_line( ui_screen, _x1, _y1, _x1, _y2, BLACK, SOLID );
   gr_line( ui_screen, _x1, _y2, _x2, _y2, BLACK, SOLID );
   gr_line( ui_screen, _x2, _y1, _x2, _y2, BLACK, SOLID );
   gr_line( ui_screen, _x1, _y1, _x2, _y1, BLACK, SOLID );

   ++_x1;
   ++_y1;
   --_x2;
   --_y2;

   /* display the title box */

   if ( t_flag != 0 )
      {

      /* calculate size of the title bar */

      ret_struct->tbar_x1 = _x1;
      ret_struct->tbar_y1 = _y2 - ( ui_grwind->fysize
	 + TITLE_YMARGIN + TITLE_YMARGIN );
      ret_struct->tbar_x2 = _x2;
      ret_struct->tbar_y2 = _y2;
      _y2 = ret_struct->tbar_y1 - 1;

      /* blank the whole title bar area before buttons */

      gr_rectangle( ui_screen, ret_struct->tbar_x1, ret_struct->tbar_y1,
	 ret_struct->tbar_x2, ret_struct->tbar_y2, ret_struct->t_bcolor,
	 SOLID );

      ret_struct->ti_x1 = ret_struct->tbar_x1;
      ret_struct->ti_y1 = ret_struct->tbar_y1;
      ret_struct->ti_x2 = ret_struct->tbar_x2;
      ret_struct->ti_y2 = ret_struct->tbar_y2;

      ret_struct->buttons = buttons;

      /* calculate close button area and display the button */

      if ( ( buttons & BUT_CLOSE ) > 0 )
	 {
	 ret_struct->bt_x1 = ret_struct->ti_x1 + ui_grwind->fxsize;
	 ret_struct->bt_y1 = ret_struct->ti_y1 + TITLE_YMARGIN;
	 ret_struct->bt_x2 = ret_struct->ti_x1
	    + ( ui_grwind->fxsize * 3 );
	 ret_struct->bt_y2 = ret_struct->ti_y2 - TITLE_YMARGIN;
	 ret_struct->ti_x1 = ret_struct->bt_x2 + 1;
	 ui_pbmcenter( ui_screen, ret_struct->bt_x1, ret_struct->bt_y1,
	    ret_struct->bt_x2, ret_struct->bt_y2, &ui_clicon );
	 }

      /* calculate move button area and display the button */

      if ( ( buttons & BUT_MOVE ) > 0 )
	 {
	 ret_struct->mv_x1 = ret_struct->ti_x2 - ( ui_grwind->fxsize * 3 );
	 ret_struct->mv_y1 = ret_struct->ti_y1 + TITLE_YMARGIN;
	 ret_struct->mv_x2 = ret_struct->ti_x2 - 2;
	 ret_struct->mv_y2 = ret_struct->ti_y2 - TITLE_YMARGIN;
	 ret_struct->ti_x2 = ret_struct->mv_x1 - 1;
	 ui_pbmcenter( ui_screen, ret_struct->mv_x1, ret_struct->mv_y1,
	    ret_struct->mv_x2, ret_struct->mv_y2, &ui_mvicon );
	 }

      /* calculate resize button area and display the button */

      if ( ( buttons & BUT_RESIZE ) > 0 )
	 {
	 ret_struct->re_x1 = ret_struct->ti_x2 - ( ui_grwind->fxsize * 3 );
	 ret_struct->re_y1 = ret_struct->ti_y1 + TITLE_YMARGIN;
	 ret_struct->re_x2 = ret_struct->ti_x2 - 2;
	 ret_struct->re_y2 = ret_struct->ti_y2 - TITLE_YMARGIN;
	 ret_struct->ti_x2 = ret_struct->re_x1 - 1;
	 ui_pbmcenter( ui_screen, ret_struct->re_x1, ret_struct->re_y1,
	    ret_struct->re_x2, ret_struct->re_y2, &ui_reicon );
	 }

      /* Draw a line under the title bar */

      gr_line( ui_screen, x1, _y2, _x2, _y2, s_color, SOLID );
	 _y2 -= 1;

      /* Display the text */

      ui_wtitle( ret_struct, t_text );

      }

   /* display the main area */

   ui_fbox( _x1, _y1, _x2, _y2, m_color, m_style );

   /* display the border */

   if ( b_flag == TRUE )
      {
      _x1 += BORDER_SIZE;
      _y1 += BORDER_SIZE;
      _x2 -= BORDER_SIZE;
      _y2 -= BORDER_SIZE;
      ui_hbox( _x1, _y1, _x2, _y2, b_color );
      _x1 += 1;
      _y1 += 1;
      _x2 -= 1;
      _y2 -= 1;
      }

   /* return coordinates of usable area */

   ret_struct->u_x1 = _x1;
   ret_struct->u_y1 = _y1;
   ret_struct->u_x2 = _x2;
   ret_struct->u_y2 = _y2;
   return ret_struct;

   }

ui_rewindow( window, newtitle )
   struct uiwindow *window;
   char *newtitle;
   {
   static int _x1, _y1, _x2, _y2;  /* counters for coordinates     */
   int s_ysize;

   if ( window == 0 )
      {
      return;
      }

   _x1 = window->x1;
   _y1 = window->y1;
   _x2 = window->x2;
   _y2 = window->y2;

   /* display the shadow */

   if ( window->s_flag != 0 )
      {
      s_ysize = (SHADOW_XSIZE * gr_pxsize ) / gr_pysize;
      ui_fbox( window->x1 + SHADOW_XSIZE, window->y1,
	 window->x2, window->y2 - s_ysize,
	 window->s_color, 1 );
      _y1 += s_ysize;
      _x2 -= SHADOW_XSIZE;
      }

   /* draw a one-pixel black line around the whole area */

   gr_line( ui_screen, _x1, _y1, _x1, _y2, BLACK, SOLID );
   gr_line( ui_screen, _x1, _y2, _x2, _y2, BLACK, SOLID );
   gr_line( ui_screen, _x2, _y1, _x2, _y2, BLACK, SOLID );
   gr_line( ui_screen, _x1, _y1, _x2, _y1, BLACK, SOLID );

   ++_x1;
   ++_y1;
   --_x2;
   --_y2;

   /* display the title box */

   if ( window->t_flag == TRUE )
      {

      gr_rectangle( ui_screen, window->tbar_x1, window->tbar_y1,
	 window->tbar_x2, window->tbar_y2, window->t_bcolor,
	 SOLID );

      ui_wtitle( window, newtitle );

      /* Draw a line under the title bar */

      _y2 = window->tbar_y1;
      _y2 -= 1;
      gr_line( ui_screen, window->x1, _y2, _x2, _y2,
	 window->s_color, SOLID );
      _y2 -= 1;

      /* display close button */

      if ( ( window->buttons & BUT_CLOSE ) > 0 )
	 {
	 ui_pbmcenter( ui_screen, window->bt_x1, window->bt_y1,
	    window->bt_x2, window->bt_y2, &ui_clicon );
	 }

      /* display move button */

      if ( ( window->buttons & BUT_MOVE ) > 0 )
	 {
	 ui_pbmcenter( ui_screen, window->mv_x1, window->mv_y1,
	    window->mv_x2, window->mv_y2, &ui_mvicon );
	 }

      /* display resize button */

      if ( ( window->buttons & BUT_RESIZE ) > 0 )
	 {
	 ui_pbmcenter( ui_screen, window->re_x1, window->re_y1,
	    window->re_x2, window->re_y2, &ui_reicon );
	 }

      }

   /* display the main area */

   ui_fbox( _x1, _y1, _x2, _y2, window->m_color, window->m_style );

   /* display the border */

   if ( window->b_flag != 0 )
      {
      _x1 += BORDER_SIZE;
      _y1 += BORDER_SIZE;
      _x2 -= BORDER_SIZE;
      _y2 -= BORDER_SIZE;
      ui_hbox( _x1, _y1, _x2, _y2, window->b_color );
      }

   }

ui_fbox( x1, y1, x2, y2, color, style )
   int x1, y1, x2, y2, color, style;
   {
#ifdef  OLD_DEBUG
   sprintf( bw_ebuf, "[pr:] ui_fbox(): %d %d %d %d", x1, y1, x2, y2 );
   bw_error( bw_ebuf );
#endif
   gr_rectangle( ui_screen, x1, y1, x2, y2, color, style );
   }

ui_hbox( x1, y1, x2, y2, color )
   int x1, y1, x2, y2, color;
   {
   gr_rectangle( ui_screen, x1, y1, x2, y2, color, HOLLOW );
   }

ui_wtitle( window, buffer )
   struct uiwindow *window;
   char *buffer;
   {

   /* show the title bar */

   gr_rectangle( ui_screen, window->ti_x1, window->ti_y1,
      window->ti_x2, window->ti_y2, window->t_bcolor,
      SOLID );

   /* display the title text */

   ui_str( window->ti_x1 + ui_grwind->fxsize,
      window->ti_y1 + TITLE_YMARGIN, window->ti_x2,
      window->t_bcolor, window->t_tcolor, buffer );

   }
