/****************************************************************

	ui_tw.c         Text Window Box under UI
			The Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023
			Duke Station
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not
	be used for illegal activities.

****************************************************************/

#include "stdio.h"
#include "bw.h"
#include "gr.h"
#include "tw.h"
#include "ui.h"

#ifdef  __STDC__
#include "malloc.h"
#else
extern  char * malloc();
#endif

struct ui_twstruct *
ui_twinit( title, rq_x1, rq_y2, rq_lines, rq_cols,
	   min_x1, min_y1, max_x2, max_y2 )
   char *title;                 /* ttle for window */
   int rq_x1;                   /* requested x1 (left, graphics) position */
   int rq_y2;                   /* requested y2 (top,  graphics) position */
   int rq_lines;                /* requested text lines */
   int rq_cols;                 /* requested text columns */
   int min_x1;                  /* leftmost   allowable position */
   int min_y1;                  /* bottommost allowable position */
   int max_x2;                  /* rightmost  allowable position */
   int max_y2;                  /* topmost    allowable position */
   {
   static struct tw_struct *tw;
   static struct ui_twstruct uitw;
   static struct uiwindow *uiwind;

   tw = tw_init( rq_x1 + 6, rq_y2 - ( ui_grwind->fysize + 8 ),
		 rq_lines, rq_cols,
		 min_x1, min_y1, max_x2, max_y2 );

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "ui_twinit(): request box: x1 %d y1 %d x2 %d y1 %d",
      tw->x1 - 3, tw->y1 - 3, tw->x2 + 3,
      tw->y2 + ui_grwind->fysize + 2 );
   bw_debug( bw_ebuf );
#endif

   uiwind = ui_window( tw->x1 - 6, tw->y1 - 8, tw->x2 + 8,
      tw->y2 + ui_grwind->fysize + 8, TRUE, WHITE, BLACK,
      title,
      TRUE, WHITE, TRUE, BLACK, BLACK, SOLID, BUT_CLOSE | BUT_MOVE | BUT_RESIZE  );

   uitw.tw = tw;
   uitw.uiw = uiwind;

   return &uitw;

   }

ui_twdeinit()
   {
   }
