/***************************************************************

	sfs.c           Space Flight Simulator
			Loader Program

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/

#include "stdio.h"
#include "string.h"
#ifdef	__STDC__
#include "process.h"
#include "stdlib.h"
#endif
#include "ctype.h"

#include "as.h"
#include "sfs.h"

#ifndef __STDC__
#define	size_t	int
#endif

/* #define SPAWN */

#define PROGBUFSIZE     64

char    sfs_program[ PROGBUFSIZE ];
char    sfs_tbuf[ 128 ];

#ifdef  SPAWN
char    arguments[ 5 ][ 64 ];
#endif

main( argc, argv )
   int argc;
   char **argv;
   {
   FILE *data;
   register int y, t;
   int n;

   strcpy( sfs_program, SFS_DEFAULTPROG );
   if ( argc > 1 )
      {
#ifdef  OLD_DEBUG
      fprintf( stderr, "Argument <%s>\n", argv[ 1 ] );
      getchar();
#endif
      strcpy( sfs_program, argv[ 1 ] );
      }

#ifdef  SPAWN
   y = spawnl( P_WAIT, SFSCH_MODEL, SFSCH_MODEL, sfs_program, NULL );
#else
   sprintf ( sfs_tbuf, "%s %s ", SFSCH_MODEL, sfs_program );
#ifdef  OLD_DEBUG
   fprintf( stderr, "SFS DEBUG: Ready to execute <%s> \n", sfs_tbuf );
   getchar();
#endif
   y = system( sfs_tbuf );
#endif

#ifdef  OLD_DEBUG
   fprintf( stderr, "y = %d \n", y );
   getchar();
#endif

   if ( y == -1 )
      {
      printf( SFS_LINKERR );
      perror( ERR_LTITLE );
      return;
      }

   while( y != -1 )
      {
      if ( ( data = fopen( SFS_CHAINFN, "r" ) ) != NULL )
	 {
	 fgets( sfs_program, PROGBUFSIZE, data );
	 fclose( data );

#ifdef  OLD_DEBUG
	 fprintf( stderr, "DEBUG: read program <%s>\n", sfs_program );
	 getchar();
#endif

	 if ( strncmp( sfs_program, SFS_EXITARG, (size_t) 4 ) == 0 )
	    {
	    unlink( SFS_CHAINFN );
	    return;
	    }
	 }
      else
	 {
	 fprintf( stderr, SFS_CHERR, sfs_program );
	 return -1;
	 }

#ifdef  SPAWN
      n = sfs_split( sfs_program );

#ifdef  OLD_DEBUG
      fprintf( stderr, "sfs_split() returned %d arguments\n", n );
#endif

      switch( n )
	 {
	 case 1:
#ifdef  OLD_DEBUG
	    fprintf( stderr, " <%s> \n", arguments[ 0 ] );
	    getchar();
#endif
	    y = spawnl( P_WAIT, arguments[ 0 ],
	       arguments[ 0 ], NULL );
	    break;
	 case 2:
#ifdef  OLD_DEBUG
	    fprintf( stderr, " <%s> <%s> \n", arguments[ 0 ],
	       arguments[ 1 ] );
	    getchar();
#endif
	    y = spawnl( P_WAIT, arguments[ 0 ], arguments[ 0 ],
	       arguments[ 1 ], NULL );
	    break;
	 case 3:
#ifdef  OLD_DEBUG
	    fprintf( stderr, " <%s> <%s> <%s> \n", arguments[ 0 ],
	       arguments[ 1 ], arguments[ 2 ] );
	    getchar();
#endif
	    y = spawnl( P_WAIT, arguments[ 0 ],
	       arguments[ 0 ], arguments[ 1 ],
	       arguments[ 2 ], NULL );
	    break;

	 }
#else
#ifdef  OLD_DEBUG
	    fprintf( stderr, " SFS: Ready to execute <%s> \n", sfs_program );
	    getchar();
#endif
      y = system( sfs_program );
#endif
      }

   perror( ERR_TTITLE );
   }

#ifdef  SPAWN
sfs_split( s )
   char *s;
   {
   int c, d;
   char *p;

   /* eat up leading whitespace */

   p = s;
   while ( isspace ( *p ))
      {
      ++p;
      }

   /* now read each argument until end of the string */

   c = d = 0;
   while ( *p != 0 )
      {

      /* read characters into the arguments buffer */

      while( ( isspace( *p ) == 0 ) && ( *p != 0 ))
	 {
	 arguments[ c ][ d ] = *p;
	 ++d;
	 ++p;
	 arguments[ c ][ d ] = 0;
	 }

      /* reset d counter and advance to next word */

      d = 0;
      ++c;

      /* eat up trailing whitespace */

      while( isspace( *p ))
	 {
	 ++p;
	 }

#ifdef  OLD_DEBUG
      printf( "DEBUG: c is %d \n", c );
#endif

      }

#ifdef  OLD_DEBUG
   printf( "DEBUG: returning %d\n", c );
#endif
   return c;

   }

#endif

