/****************************************************************

	sfsx_cp.c	Screen Setup and
			Control Panel Routines for SFS,
			Simulation Module

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#define SIDE_SPACE      (gr_strlen("S"))       /* spacing for side of boxes */
/* #define SMALL_DEBUG */
#define MAXYSIZE	375

#include "stdio.h"
#include "math.h"

#ifdef   __STDC__
#include "stdlib.h"
#include "malloc.h"
#else
extern char *malloc();
#define	time_t long
#define	size_t int
#endif

#include "time.h"
#include "sfsx.h"

struct tm *tp;

sfsx_screen()
   {

#ifdef  OLD_DEBUG
   fprintf( stderr, "sfsx_screen(): enter function\n" );
#endif

   /* Clear the screen */

   gr_cls( GR_PRIMARY );

   /* Draw the main screen */

   cp_ms();

   /* Draw control panel boxes */

   cp_boxes();

   }

cp_prog( progfile )
   char *progfile;
   {
   sprintf( sfsx_tbuf, "%s: %s", progfile, pr_name );

   ui_text( po_window->u_x1 + SIDE_SPACE,
      po_window->u_y1,
      po_window->u_x2,
      po_window->u_y2,
      256,
      cl_mback, cl_mfore, sfsx_tbuf );
   }

cp_sti()
   {
   static char clock_buf[ 36 ];
   static char env_buf[ 48 ];
   static time_t ticks;
   register int c;

   ticks = (time_t) ( sfsx_epoch + sfsx_getmet());
   tp = gmtime( &ticks );

#ifdef  DEBUG
   if ( tp == NULL )
      {
      bw_error( "[pr:] cp_sti(): tp returns NULL" );
      return BW_ERROR;
      }
#endif

   sprintf( clock_buf, "UTC: %02d:%02d:%02d",
      tp->tm_hour, tp->tm_min, tp->tm_sec );
   ui_str( ti_window->u_x1 + SIDE_SPACE,
      ti_window->u_y2 - ui_grwind->fysize,
      ti_window->u_x2,
      cl_mback, cl_mfore, clock_buf );
   tp = localtime( &ticks );
   if ( getenv( "TZ" ) == NULL )
      {
      strcpy( env_buf, "LOC" );
      }
   else
      {
      strcpy( env_buf, getenv( "TZ" ) );
      }
   if ( tp->tm_isdst == 0 )
      {
      env_buf[ 3 ] = 0;
      }
   else
      {
      for ( c = 0; c < 4; ++c )
         {
         env_buf[ c ] = env_buf[ c + 4 ];
         }
      }
   sprintf( clock_buf, ": %02d:%02d:%02d",
      tp->tm_hour, tp->tm_min, tp->tm_sec );
   strcat( env_buf, clock_buf );
   ui_str( ti_window->u_x1 + SIDE_SPACE,
      ti_window->u_y2 - ( 2 * ui_grwind->fysize ),
      ti_window->u_x2,
      cl_mback, cl_mfore, env_buf );
   sprintf( clock_buf, "%s: %ld %s", SFSX_MET,
      sfsx_getmet() / (long) 86400, SFSX_DAYS );
   ui_str( ti_window->u_x1 + SIDE_SPACE,
      ti_window->u_y2 - ( 3 * ui_grwind->fysize ),
      ti_window->u_x2,
      cl_mback, cl_mfore, clock_buf );
   ticks = sfsx_getmet() + EL_EPOCH;
   if ( ( tp = gmtime( &ticks )) == NULL )
      {
      sprintf( clock_buf, " " );
      }
   else
      {
      sprintf( clock_buf, "%s: %02d:%02d:%02d ", SFSX_MET,
         tp->tm_hour, tp->tm_min, tp->tm_sec );
      }
   ui_str( ti_window->u_x1 + SIDE_SPACE,
      ti_window->u_y2 - ( 4 * ui_grwind->fysize ),
      ti_window->u_x2,
      cl_mback, cl_mfore, clock_buf );
   }

/*      Main SFS Screen         */

cp_ms()
   {

   /* Draw the window itself */

   sprintf( sfsx_tbuf, SFSX_TITLE, VERSION );
   main_window = ui_window( 0, 0, ui_grwind->xmax, ui_grwind->ymax,
      TRUE, cl_marker, cl_mfore, sfsx_tbuf,
      FALSE, cl_mback, FALSE, BLACK, cl_mback, GRID, BUT_CLOSE );

#ifdef  OLD_DEBUG
   kb_rx();
#endif

   /* Draw two lines demarcating help area */

   gr_line( GR_PRIMARY, ui_grwind->xmax / 2, main_window->tbar_y1,
      ui_grwind->xmax / 2, main_window->y2, cl_mfore, SOLID );
   gr_line( GR_PRIMARY, ( ui_grwind->xmax / 2 ) + 2,
      main_window->tbar_y1,
      ( ui_grwind->xmax / 2 ) + 2,
      main_window->y2, cl_mfore, SOLID );

   /* Record the help area */


   help_y1 = main_window->tbar_y1;
   help_y2 = main_window->y2 + ( ( ui_grwind->fysize ) * 0.3 );
   help_x1 = ( main_window->x2 / 2 ) + 5;
   help_x2 = main_window->tbar_x2;

   }

/*      SFS Help Display */

sfsx_help( mes )
   char *mes;
   {
   ui_fbox( help_x1, main_window->tbar_y1,
      main_window->tbar_x2, main_window->tbar_y2,
      cl_marker, SOLID );

   ui_str( help_x1, help_y1, help_x2,
      cl_marker, BLACK, mes );

   }

/*      Set up Control Panel Windows */

cp_boxes()
   {
   int x1, x2, y1, y2, height, cp_side, decrement;
   cp_side = ( ui_grwind->xmax / 9 ) * 2;

   /* blank the box area */

   cp_window = ui_window( main_window->u_x1, main_window->u_y1,
      cp_side, main_window->u_y2,
      FALSE, cl_mback, cl_mfore, "",
      FALSE, cl_mback, FALSE, BLACK, BLACK, SOLID, FALSE );

   fo_window = ui_window( cp_side, main_window->u_y1,
      main_window->u_x2, main_window->u_y2,
      FALSE, cl_mback, cl_mfore, "",
      TRUE, cl_mback, FALSE, BLACK, cl_mback, GRID, FALSE );

   ui_fbox( fo_window->u_x1, fo_window->u_y1, fo_window->u_x2,
      fo_window->u_y2, WHITE, GRID );

   decrement = ( ( cp_window->u_y2 - cp_window->u_y1 ) / 3 ) - 8;

   y2 = cp_window->u_y2 - 2;
   y1 = cp_window->u_y2 - decrement;
   x1 = cp_window->u_x1 + 2;
   x2 = cp_window->u_x2 - 2;

   po_window = ui_window( x1, y1, x2, y2, TRUE, cl_marker, BLACK,
      SFSX_PROG, FALSE, cl_mback, FALSE, BLACK, cl_mback, SOLID, FALSE );

   y2 = y1 - 2;
   y1 = y2 - decrement;

   ti_window = ui_window( x1, y1, x2, y2, TRUE, cl_marker, BLACK,
      SFSX_TIME, FALSE, BLACK, FALSE, BLACK, WHITE, SOLID, FALSE );

   y2 = y1 - 2;
   y1 = cp_window->u_y1 + 2;

   sy_window = ui_window( x1, y1, x2, y2, TRUE, cl_marker, BLACK,
      SFSX_SYS, FALSE, BLACK, FALSE, BLACK, WHITE, SOLID, FALSE );

   }

/****************************************************************

	cp_lwin()       Draw large focus window

****************************************************************/

cp_lwin( uiwind, title )
   struct uiwindow **uiwind;
   char *title;
   {

   if ( *uiwind == NULL )
      {
      *uiwind = ui_window( fo_window->u_x1, fo_window->u_y1,
	 fo_window->u_x2, fo_window->u_y2, TRUE, cl_marker, FALSE,
	 title, FALSE, BLACK, FALSE, BLACK, BLACK, SOLID, FALSE );
      }
   else
      {
      ui_rewindow( *uiwind, title );
      }

   }

/****************************************************************

	cp_twin()       Draw small top focus window

****************************************************************/

cp_twin( uiwind, title )
   struct uiwindow **uiwind;
   char *title;
   {
   int midx, midy;

   if ( *uiwind == NULL )
      {

      midx = fo_window->u_x1 + ( ( fo_window->u_x2 - fo_window->u_x1 ) / 2 );
      midy = fo_window->u_y1 + ( ( fo_window->u_y2 - fo_window->u_y1 ) / 2 );

      *uiwind = ui_window(
	 fo_window->u_x1 + 1,
	 midy + 1,
	 fo_window->u_x2 - 1,
	 fo_window->u_y2 - 1,
	 TRUE, cl_marker, BLACK,
	 title, TRUE, WHITE, FALSE, BLACK, BLACK, SOLID, FALSE );

      }
   else
      {
      ui_rewindow( *uiwind, title );
      }

   }

/****************************************************************

	cp_bwin()       Draw small bottom focus window

****************************************************************/

cp_bwin( uiwind, title )
   struct uiwindow **uiwind;
   char *title;
   {
   int midx, midy;

   if ( *uiwind == NULL )
      {

      midx = fo_window->u_x1 + ( ( fo_window->u_x2 - fo_window->u_x1 ) / 2 );
      midy = fo_window->u_y1 + ( ( fo_window->u_y2 - fo_window->u_y1 ) / 2 );

      *uiwind = ui_window(
	 fo_window->u_x1 + 1,
	 fo_window->u_y1 + 1,
	 fo_window->u_x2 - 1,
	 midy - 1,
	 TRUE, cl_marker, FALSE,
	 title, TRUE, WHITE, FALSE, BLACK, BLACK, SOLID, FALSE );
      }
   else
      {
      ui_rewindow( *uiwind, title );
      }
   }

sfsx_font( size )
   int size;
   {
   static int oldsize = 159;
   int rq_height, calcy;

   if ( size == oldsize )
      {
      return;
      }

   if ( ui_grwind->ymax > MAXYSIZE )
      {
      calcy = MAXYSIZE;
      }
   else
      {
      calcy = ui_grwind->ymax;
      }

   switch( size )
      {
      case 1:
	 rq_height = calcy / 25;
         break;
      case 2:
	 rq_height = calcy / 15;
         break;
      default:
	 rq_height = calcy / 30;
         break;
      }

   gr_font( GR_PRIMARY, F_DEFAULT, rq_height );
   }

bw_message( mes )
   char *mes;
   {
   ui_fbox( sy_window->u_x1, sy_window->u_y1, sy_window->u_x2,
      sy_window->u_y2,
      cl_mback, SOLID );
   ui_text( sy_window->u_x1 + SIDE_SPACE, sy_window->u_y1,
      sy_window->u_x2, sy_window->u_y2,
      5, cl_mback, cl_mfore, mes );
   }

err_init()
   {
   static size_t x_size;
   static int x1, x2, y1, y2, height, length, midx, midy, c;

#ifdef OLD_DEBUG
   fprintf( stderr, "err_init(): enter function\n" );
#endif

   midx = main_window->u_x1 + ( ( main_window->u_x2 - main_window->u_x1 ) / 2 );
   midy = main_window->u_y1 + ( ( main_window->u_y2 - main_window->u_y1 ) / 2 );

#ifdef OLD_DEBUG
   fprintf( stderr, "err_init(): calculate length\n" );
#endif

   length = main_window->u_x2 / 2;
   x1 = midx - length / 2;
   x2 = midx + length / 2;
   height = main_window->u_y2 / 2;
   y1 = midy - height / 2;
   y2 = midy + height / 2;

#ifdef OLD_DEBUG
   fprintf( stderr, "err_init(): call imsize\n" );
#endif

   }

bw_error( mes )
   char *mes;
   {
   static char buffer[ BW_EBUFSIZE ];
   static int x1 = 0, x2, y1, y2, height, length, midx, midy, c;
   static struct  uiwindow *err_window;           /* structure for error window   */
   static int err_mem;

   if ( err_mem == NULL )
      {
      fprintf( stderr, "ERROR: %s\n", mes );
      kb_rx();
      return 0;
      }

   if ( x1 == 0 )
      {

      midx = main_window->u_x1 + ( ( main_window->u_x2 - main_window->u_x1 ) / 2 );
      midy = main_window->u_y1 + ( ( main_window->u_y2 - main_window->u_y1 ) / 2 );

      length = main_window->u_x2 / 2;
      x1 = midx - length / 2;
      x2 = midx + length / 2;
      height = main_window->u_y2 / 2;
      y1 = midy - height / 2;
      y2 = midy + height / 2;

      }

   ui_push();                           /* save ui screen */
   ui_setscreen( GR_PRIMARY );
   gr_imsave( GR_PRIMARY, TRUE, x1, y1, x2, y2, &err_mem );
   buffer[ 0 ] = 0;
   sprintf( buffer, ERR_PROMPT, mes );
   c = ui_yn( x1, y1, x2, y2, cl_mback, cl_mfore, cl_marker, TRUE,
      buffer, ERRP_NO, ERRP_YES, &err_window );
   gr_imsave( GR_PRIMARY, FALSE, x1, y1, x2, y2, &err_mem );
   gr_imfree( err_mem );

   if ( c == FALSE )
      {
      sfs_exit();
      exit( 1 );
      }
   sfsx_help( SFSX_HELP );
   ui_pop();
   }

#ifdef  DEBUG
bw_debug( mes )
   char *mes;
   {
   static char buffer[ 256 ];
   static int x_mem;
   static size_t x_size;
   static int x1 = 0, x2, y1, y2, height, length, midx, midy, c;
   static struct  uiwindow *d_window;      /* structure for debug window   */

#ifdef  SMALL_DEBUG
   sprintf( buffer, "DEBUG: %s     ", mes );
   gr_text( GR_PRIMARY, 5, 5, buffer, BLACK, WHITE );
   ui_wait();
#else
   if ( x1 == 0 )
      {

      midx = main_window->u_x1 + ( ( main_window->u_x2 - main_window->u_x1 ) / 2 );
      midy = main_window->u_y1 + ( ( main_window->u_y2 - main_window->u_y1 ) / 2 );

      length = main_window->u_x2 / 2;
      x1 = midx - length / 2;
      x2 = midx + length / 2;
      height = main_window->u_y2 / 2;
      y1 = midy - height / 2;
      y2 = midy + height / 2;

      }

   ui_push();                           /* save ui screen */
   ui_setscreen( GR_PRIMARY );
   gr_imsave( GR_PRIMARY, TRUE, x1, y1, x2, y2, &x_mem );
   buffer[ 0 ] = 0;
   sprintf( buffer, "DEBUG: %s", mes );
   c = ui_alarm( x1, y1, x2, y2, cl_mback, cl_mfore, cl_marker, TRUE,
      buffer, " OK ", &d_window );
   gr_imsave( GR_PRIMARY, FALSE, x1, y1, x2, y2, &x_mem );
   gr_imfree( x_mem );

   ui_pop();

#endif
   }
#endif

ui_error( m )
   char *m;
   {
   bw_error( m );
   }

matherr( xstruct )
   struct exception *xstruct;
   {
   sprintf( bw_ebuf, ERR_MATH, xstruct->name );
   bw_error( bw_ebuf );
   }


