/****************************************************************************/
/*                                                                          */
/*  Converts HPGL files to AutoCAD script files.  HPGL file must have       */
/*  extension ".PLT", and script file will have extension ".SCR".  To       */
/*  find out more information, consult the "HP ColorPro Graphics Plotter    */
/*  Programming Manual" available from HP, your AutoCad manual, and "Using  */
/*  AutoCAD, 3rd Edition" by QUE Corporation.                               */
/*                                                                          */
/*  This program copyright (c) 1991 by William D. Palmer, 1313 Vickers Ave. */
/*  Durham, NC  27707.  The program is released into the public domain,     */
/*  and any commercial use without the prior written consent of the         */
/*  copyright holder is prohibited.  No warranty as to the suitability of   */
/*  this software for any particular purpose is expressed or implied.       */
/*                                                                          */
/*  HPGL2SCR.C                                                   12 SEP 91  */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#undef  DEBUG
#define BUFFSIZE 12800
#define DOWN 0x01
#define UP   0x00

char pen = UP, *ptr, *endptr, buffer[BUFFSIZE],
     infile_line[80], infile_name[80], outfile_name[80];

double AX, AY, height, M1X, M1Y, M2X, M2Y, width, X, Y, params[20];

FILE *infile, *outfile;

int P1X = 250, P1Y = 279, P2X = 10250, P2Y = 7479,
    U1X = 250, U1Y = 279, U2X = 10250, U2Y = 7479,
    X_RANGE = 10000, Y_RANGE = 7200,
    characters, index, jndex, kndex;

void init_eq (void)
  {
  M1X = (P2X - P1X) / (U2X - U1X);
  M2X = P1X - U1X * M1X;
  M1Y = (P2Y - P1Y) / (U2Y - U1Y);
  M2Y = P1Y - U1Y * M1Y;
  }

void get_coords (void)
  {
  X = (M1X * AX + M2X) / 1000;
  Y = (M1Y * AY + M2Y) / 1000;
  }

void main (int argc, char *argv[])
  {
/* Link floating point library; bug in Turbo C 2.0 */
  X = exp (1);

/* Open requisite files. */
  if (argc == 1)
    {
    printf ("File To Filter   : ");
    scanf ("%s", &infile_name);
    }
  else strcpy (infile_name, argv[1]);
  if (strrchr (infile_name, '.') == NULL)
    {
    strcpy (outfile_name, infile_name);
    strcat (infile_name, ".PLT");
    strcat (outfile_name, ".SCR");
    }
  else
    {
    index = 0;
    while (infile_name[index] != '.')
      outfile_name[index] = infile_name[index++];
    strcat (outfile_name, ".SCR");
    }
  infile = fopen (infile_name, "r");
  outfile = fopen (outfile_name, "w");

#ifdef DEBUG
  printf ("%s, %s\n", infile_name, outfile_name);
  printf ("%p, %p\n", infile, outfile);
  (void) getch ();
#endif DEBUG

/* Initialize scaling equation. */
  init_eq ();
  strcpy (infile_line, "");
  jndex = 0;

/* Process the input file until done. */
  while (!feof (infile))
    {
    index = 0;
    characters = fread (buffer, 1, BUFFSIZE, infile);
#ifdef DEBUG
  printf ("characters = %d\n", characters);
  (void) getch ();
#endif DEBUG
    while (index < characters)
      {
      if ((buffer[index] != 0x0d) && (buffer[index] != 0x0a))
	infile_line[jndex++] = buffer[index];
      if (buffer[index++] == ';')
	{
#ifdef DEBUG
  printf ("\n");
#endif DEBUG
	printf ("#");
	infile_line[jndex] = 0x00;

/* Here's where the HPGL commands get processed into AUTOCAD script. */
#ifdef DEBUG
  printf ("%s\n", infile_line);
#endif DEBUG

/* Process LB instruction.  If it's an LB, other command strings could  */
/* appear in the message line.                                          */
      if ((ptr = strstr (infile_line, "LB")) != NULL)
	{
#ifdef DEBUG
  printf ("Processing LB instruction\n");
#endif DEBUG
	fprintf (outfile ,"TEXT %lf,%lf   ", X, Y);
	kndex = 2;
	while (infile_line[kndex] != 0x03)
	  fprintf (outfile, "%c", infile_line[kndex++]);
	fprintf (outfile, "\n");
	} /* if LB */
      else
	{

/* Process IP instruction. */
      if ((ptr = strstr (infile_line, "IP")) != NULL)
	{
#ifdef DEBUG
  printf ("Processing IP instruction\n");
#endif DEBUG
	kndex = 0;
	endptr = ptr += 2;
	while (strchr (";ABCDILPRSU", (int) *endptr) == NULL)
	  {
	  params[kndex] = strtod (ptr, &endptr);
	  ptr = endptr + 1;
#ifdef DEBUG
  printf ("%lf ", params[kndex]);
  printf ("%i\n", kndex);
#endif DEBUG
	  kndex++;
	  } /* while */
	switch (kndex)
	  {
	  case 0 : P1X = 250; P1Y = 279; P2X = 10250; P2Y = 7479;
		   X_RANGE = 10000; Y_RANGE = 7200; init_eq (); break;
	  case 1 : break;
	  case 2 : P1X = (int) params[0]; P1Y = (int) params[1];
		   P2X = P1X + X_RANGE; P2Y = P1Y + Y_RANGE;
		   init_eq (); break;
	  case 3 : break;
	  case 4 :
	  default: P1X = (int) params[0]; P1Y = (int) params[1];
		   P2X = (int) params[2]; P2Y = (int) params[3];
		   X_RANGE = P2X - P1X; Y_RANGE = P2Y - P1Y;
		   init_eq (); break;

	  } /* switch */
#ifdef DEBUG
  (void) getch ();
#endif DEBUG
	} /* if IP */

/* Process SC instruction. */
      if ((ptr = strstr (infile_line, "SC")) != NULL)
	{
#ifdef DEBUG
  printf ("Processing SC instruction\n");
#endif DEBUG
	kndex = 0;
	endptr = ptr += 2;
	while (strchr (";ABCDILPRSU", (int) *endptr) == NULL)
	  {
	  params[kndex] = strtod (ptr, &endptr);
	  ptr = endptr + 1;
#ifdef DEBUG
  printf ("%lf ", params[kndex]);
  printf ("%i\n", kndex);
#endif DEBUG
	  kndex++;
	  } /* while */
	switch (kndex)
	  {
	  case 0 : U1X = P1X; U1Y = P1Y; U2X = P2X; U2Y = P2Y;
		   init_eq (); break;
	  case 1 :
	  case 2 :
	  case 3 : break;
	  case 4 :
	  default: U1X = (int) params[0]; U2X = (int) params[1];
		   U1Y = (int) params[2]; U2Y = (int) params[3];
		   if ((U1X == U2X) || (U1Y == U2Y))
		     {
		     U1X = P1X; U1Y = P1Y; U2X = P2X; U2Y = P2Y;
		     }
		   init_eq (); break;
	  } /* switch */
	} /* if SC */

/* Process SR instruction. */
      if ((ptr = strstr (infile_line, "SR")) != NULL)
	{
#ifdef DEBUG
  printf ("Processing SR instruction\n");
#endif DEBUG
	kndex = 0;
	endptr = ptr += 2;
	while (strchr (";ABCDILPRSU", (int) *endptr) == NULL)
	  {
	  params[kndex] = strtod (ptr, &endptr);
	  ptr = endptr + 1;
#ifdef DEBUG
  printf ("%lf ", params[kndex]);
  printf ("%i\n", kndex);
#endif DEBUG
	  kndex++;
	  } /* while */
	switch (kndex)
	  {
	  case 1 :
	  case 2 : width  = X_RANGE * 0.0075 / 1000.0;
		   height = Y_RANGE * 0.0150 / 1000.0;
		   break;
	  case 3 :
	  default: width  = params[0] / 100000.0 * X_RANGE;
		   height = params[1] / 100000.0 * Y_RANGE;
		   break;
	  } /* switch */
	if (pen) fprintf (outfile, "\n");
	fprintf (outfile, "STYLE  TXT %lf %lf    ", height, (width/height));
	if (!pen) fprintf (outfile, "\n");
#ifdef DEBUG
  printf ("STYLE  TXT %lf %lf    #\n", height, (width/height));
  (void) getch ();
#endif DEBUG
	} /* if SR */

/* Process PD instruction. */
      if ((ptr = strstr (infile_line, "PD")) != NULL)
	{
#ifdef DEBUG
  printf ("Processing PD instruction\n");
#endif DEBUG
	if (!pen)
	  {
	  pen = DOWN;
	  fprintf (outfile, "LINE %lf,%lf ", X, Y);
	  } /* if (!pen) */
	endptr = ptr += 2;
	while (strchr (";ABCDILPRSU", (int) *endptr) == NULL)
	  {
	  AX = strtod (ptr, &endptr);
#ifdef DEBUG
  printf ("%lf,", AX);
#endif DEBUG
	  ptr = endptr + 1;
	  AY = strtod (ptr, &endptr);
#ifdef DEBUG
  printf ("%lf -> ", AY);
#endif DEBUG
	  ptr = endptr + 1;
	  get_coords ();
	  fprintf (outfile, "%lf,%lf ", X, Y);
#ifdef DEBUG
  printf ("%lf,%lf\n", X, Y);
#endif DEBUG
	  } /* while */
	} /* if PD */

/* Process PA instruction. */
      if ((ptr = strstr (infile_line, "PA")) != NULL)
	{
#ifdef DEBUG
  printf ("Processing PA instruction\n");
#endif DEBUG
	endptr = ptr += 2;
	while (strchr (";ABCDILPRSU", (int) *endptr) == NULL)
	  {
	  AX = strtod (ptr, &endptr);
#ifdef DEBUG
  printf ("%lf,", AX);
#endif DEBUG
	  ptr = endptr + 1;
	  AY = strtod (ptr, &endptr);
#ifdef DEBUG
  printf ("%lf -> ", AY);
#endif DEBUG
	  ptr = endptr + 1;
	  get_coords ();
	  if (pen) fprintf (outfile, "%lf,%lf ", X, Y);
#ifdef DEBUG
  printf ("%lf,%lf\n", X, Y);
#endif DEBUG
	  } /* while */
	} /* if PA */

/* Process PU instruction. */
      if ((ptr = strstr (infile_line, "PU")) != NULL)
	{
#ifdef DEBUG
  printf ("Processing PU instruction\n");
#endif DEBUG
	if (pen) fprintf (outfile, "\n");
	pen = UP;
	endptr = ptr += 2;
	while (strchr (";ABCDILPRSU", (int) *endptr) == NULL)
	  {
	  AX = strtod (ptr, &endptr);
#ifdef DEBUG
  printf ("%lf,", AX);
#endif DEBUG
	  ptr = endptr + 1;
	  AY = strtod (ptr, &endptr);
#ifdef DEBUG
  printf ("%lf -> ", AY);
#endif DEBUG
	  ptr = endptr + 1;
#ifdef DEBUG
  printf ("%lf,%lf\n", X, Y);
#endif DEBUG
	  } /* while */
	} /* if PU */

	} /* else LB */

/* re-initialize infile_line */
	strcpy (infile_line, "");
	jndex = 0;
	} /* if buffer[index] == ';' */
      } /* while (index < characters) */
    } /* while (!feof (infile)) */
  fprintf (outfile, "REDRAW ");
  fclose (infile);
  fclose (outfile);
#ifdef DEBUG
  printf ("infile closed\n");
  printf ("outfile closed\n");
#endif DEBUG
  } /* main */
