;MULTIPLT batch compatible plotting program that can plot multiple
;drawings to multiple plotters, at varying scales, size, scale, pen
;settings, units, and rotation

;This program is used in conjunction with SAVEPCP.LSP and SAVEPCPB.LISP
;to batch plot and automate even single drawing plots. 

;See MULTIPLT.TXT for more information.

;You can speed this program up by setting the repeat number following the line that says

;**** Set this number to the highest color number you drawings use ****	

;to the highest color number your drawings use.

;Sierra Hermitage
;Rod Young, programmer
;140 Mesa Vista Drive
;Bishop, CA  93514
;Phone 619-387-2479 (voice)   619-387-2488 (data/fax, seldom enabled)
;E-mail hermit1@ix.netcom.com

(defun multiplt()
   ;get eed string
   (setq strg(cdr(assoc 1000(cdr(assoc "SAVEPCP"(cdr(assoc -3 (entget (entnext)(list "SAVEPCP")))))))))
	(setq flag nil)
   (if (= (findfile (strcat (getvar "DWGNAME") ".PLT")) (strcat (getvar "DWGNAME") ".PLT"))
   	(setq flag T )
   );end if
   (if strg (progn
      ;parse the eed variables
      (setq count 10)
      (while (/= (substr strg count 1) "|")
         (setq count (1+ count))
      );end while
      (setq pcp(substr strg 11 (- count 12)))
      (setq strg(substr strg (1+ count)))
      (setq count 1)
      (while (/= (substr strg count 1) "|")
         (setq count (1+ count))
      );end while
      (setq pid(substr strg 11 (- count 12)))
      (setq pscale(substr strg (+ count 10)))
      (setq ifile(open pcp "r"))
      (repeat 6(read-line ifile));get rid of headers
      (setq uunits (substr(read-line ifile) 10);units
         uorigin (substr(read-line ifile) 10);orign - not used
         usize (substr(read-line ifile) 8);size
         urotate(substr(read-line ifile) 10);rotate
         uhide(substr(read-line ifile) 9);hide
         upenw(substr(read-line ifile) 13);pen width
         uscale(read-line ifile);scale - not used
         upfile(read-line ifile);plot filename - not used
         ufill(substr(read-line ifile) 16);fill adjust
         uopt(substr(read-line ifile) 18);optimize level
      );end setq
      (if (= (substr usize 1 1) "U")(setq usize (substr usize 7)))
      ;begin plotting sequence
      (command "_plot" "view" "plotview" "y");tell acad we're changing default plot setup 
      (command "y" pid);change plotters prompt
      (command "view" "plotview");what to plot
      (command "y");tell acad there is more to change
      (command "n");tell acad plotter is okay
      ;	(command "y")										;tell acad there is more to change
      (command "");respond to time-out default
      (command "");respond to hard clip default
      (command "y");tell acad we want to change pen settings
      ;begin loop for pen settings
      (setq count 1)
      ;**** Set this number to the highest color number you drawings use ****	
      (repeat 3
         (read-line ifile);waste a line
         (setq ucolor(substr(read-line ifile) 15);color number
            upen(substr(read-line ifile) 16);pen
            ult(substr(read-line ifile) 17);line type
            uspeed(substr(read-line ifile) 15);pen speed
            uweight(substr(read-line ifile) 16);pen weight
         );end setq
         (read-line ifile);waste a line
         (command (strcat "c" ucolor))
         (command upen)
         (command ult)
         (command uspeed)
         (command uweight)
         (setq count (1+ count))
      );end repeat
      ;now do last one
      (read-line ifile);waste a line
      (setq ucolor(substr(read-line ifile) 15);color number
         upen(substr(read-line ifile) 16);pen
         ult(substr(read-line ifile) 17);line type
         uspeed(substr(read-line ifile) 15);pen speed
         uweight(substr(read-line ifile) 16);pen weight
      );end setq
      (command (strcat "c" (itoa count)))
      (command upen)
      (command ult)
      (command uspeed)
      (command uweight)
      (command "x");exist pen setup
      (command "y");write to plot file
      (command uunits);units
      (command "0,0");origin
      (command usize);size
      (command urotate);rotation
      (command ufill);fill
      (command uhide);hide
      (command pscale);scale
      (command (strcat (getvar "DWGNAME") ".PLT"))
      ;overwrite old plot if needed
      (if flag
         (command "y" )
      );end if
      (close ifile)
      (princ);clean run
   );end progn
   (prompt (strcat "\nCan't plot " (getvar "dwgname") " - please run SAVEPCP.LSP first"))
   );end if
);end defun
;make this program 'load and go' by running itself
;be sure to do this for all programs to be used with RUN LISP
;(multiplt)
(multiplt)	'make this program 'load & go' - do this for all RUN LISP compatible programs.
