;SAVEPCPB program to save plot setup info as EED attached to first
;entity in the drawing - in batch mode

;This program is used in conjunction with MULTIPLT.LSP to batch plot
;See MULTIPLT.TXT for more information

;Sierra Hermitage
;Rod Young, programmer
;140 Mesa Vista Drive
;Bishop, CA  93514
;Phone 619-387-2479 (voice)   619-387-2488 (data/fax, seldom enabled)
;E-mail hermit1@ix.netcom.com

(defun savepcpb()
	(setq ifile(open "prams.txt" "r"))
	(princ ifile)
	(setq pcp(read-line ifile))
	(setq	pscale(atoi(read-line ifile)))
	(setq	pid(read-line ifile))
			(close ifile)
	;register this application
	(if (tblsearch "appid" "SAVEPCP")
		(princ (strcat "\nSAVEPCP already exist."))
		;register your app and check success
		(if (= (regapp "SAVEPCP") nil)
			(princ (strcat "\nCan't register XDATA for SAVEPCP."))
		);end if
	);end if
	;add eed to first entity in the drawing
	(setq strg(strcat "PCP FILE: " pcp " | PLOTTER: " pid " |  SCALE: " (rtos pscale 2 2)))
	(setq extdta (list (list -3 (list "SAVEPCP" (cons 1000 strg)))))
	;now add it to entity
	(setq ent(entget(entnext)))
	(setq ent(append ent extdta))
	;now update the entity
	(entmod ent)
	(command "-qsave")
);end defun
(savepcpb)	;make this program 'load & go' - batch compatible

