; ************************************************************
;* Comando tabla
;* Este comando se usa para insertar un archivo de texto (ASCII)
;* que generalmente corresponde al listado de materiales.
;* Al insertar el texto automaticamente dibuja una linea entre la\s
;* filas de texto.
;* El archivo de texto se puede generar con una hoja de calculo
;* (lotus 1-2-3 etc.)
;*
;*
;* Pregunta los siguientes datos:
;* - Nombre archivo : debe ingresarse el nombre del archivo de texto con
;*                    la extension y su path.
;* - Altura texto   : debe ingresar la altura del texto ya sea desde el
;*                    teclado o con el mouse.
;* - Espacio entre texto : debe ingresar la distancia entre las filas de
;*                         texto ya sea desde el teclado o con el mouse.
;* - Punto de insercion : debe ingresar el punto donde se quiere empesar
;*                        a escribir el texto ya sea con el teclado o el
;*                        mouse


(defun c:tabla ()

;* recordar quitar osnap, commandecho etc.
 
 (setq pi 3.141516)
 (setq pi/2 (/ pi 2.0))
 
 (setq nombreArchivo     (getstring "\nNombre archivo: "))
 (setq alturaTexto       (getdist   "\nAltura texto: "))
 (setq espacioEntreTexto (getdist   "\nEspacio entre texto: "))
 (setq insercion         (getpoint  "\nPunto de insercion: "))

 (setq archivo (open nombreArchivo "r"))
 (if (not archivo) 
     (progn
         (princ (strcat "\nEl archivo: " nombreArchivo " no existe."))
         (exit)
     )
  )


 (setq numeroDeFilas 0)
 (setq largoLinea  0)
 (setq listaTexto nil)
 ;
 ; leemos la filas y calculamos el largo de la fila mas larga
 ;
 (while archivo
     (setq texto (read-line archivo))
     (if texto 
         (progn
            (setq numeroDeFilas (+ numeroDeFilas 1))
            (if (> (strlen texto) largoLinea) (setq largoLinea (strlen texto)))
            (setq listaTexto (append listaTexto (list texto)))
         )
         (setq archivo nil)
      )
  )
  ;
  ; dibujamos la informacion en la pantalla
  ;
  (setq largoLinea (* largoLinea alturaTexto))
  (setq insercion (polar insercion  pi/2 (/ espacioEntreTexto 2.0)))
  (repeat numeroDeFilas
      
      (setq texto (car listaTexto))
      (setq listaTexto (cdr listaTexto))
      
      (command "text" insercion alturaTexto 0 texto )
      
      (setq insercionLinea (polar insercion (- pi/2) (/ espacioEntreTexto 2.0)))
      (setq insercion (polar insercion (- pi/2) (+ alturaTexto espacioEntreTexto)))
      
      (command "line" insercionLinea (polar insercionLinea 0 largoLinea) "")
   )
)
