'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |   PBClone  (C) Copyright 1996 Charon Software, All Rights Reserved   |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE SUB FClose1 (BYVAL FileHandle%)
   DECLARE SUB FOpen1 (FileName$, BYVAL ReadWrite%, BYVAL Sharing%, FileHandle%, ErrCode%)
   DECLARE SUB FReadLine (FileHandle%, Dest$, DLen%, TooLong%, ErrCode%)


FUNCTION FDescRead$ (FileName$)

   IF LEN(FileName$) = 0 THEN
      FDescRead$ = ""
      EXIT FUNCTION
   END IF

   Path$ = FileName$
   File$ = ""
   Done% = 0
   DO
      ch$ = RIGHT$(Path$, 1)
      IF LEN(ch$) = 0 OR ch$ = ":" OR ch$ = "\" OR ch$ = "/" THEN
         Done% = -1
      ELSE
         Path$ = LEFT$(Path$, LEN(Path$) - 1)
         File$ = ch$ + File$
      END IF
   LOOP UNTIL Done%

   IF LEN(File$) = 0 THEN
      FDescRead$ = ""
      EXIT FUNCTION
   END IF

   FOpen1 Path$ + "DESCRIPT.ION", 0, 2, Handle%, ErrCode%
   IF ErrCode% THEN
      FDescRead$ = ""
      EXIT FUNCTION
   END IF

   St$ = SPACE$(256)
   L% = LEN(File$)
   DO
      FReadLine Handle%, St$, SLen%, TooLong%, ErrCode%
      Found% = (UCASE$(LEFT$(LEFT$(St$, SLen%), L%)) = File$)
   LOOP UNTIL Found% OR ErrCode%
   FClose1 Handle%

   IF Found% THEN
      St$ = LEFT$(St$, SLen%)
      tmp% = INSTR(St$, " ")
      IF tmp% THEN
         St$ = LTRIM$(MID$(St$, tmp% + 1))
         tmp% = INSTR(St$, CHR$(4))
         IF tmp% THEN St$ = LEFT$(St$, tmp% - 1)
         FDescRead$ = St$
      ELSE
         FDescRead$ = ""
      END IF
   ELSE
      FDescRead$ = ""
   END IF

END FUNCTION
