SUB CREDITS STATIC

REM PUTS UP CREDITS WHEN PROGRAM INVOKED

DEFINT A-Z
SEC = 3
CLS
KEY OFF

RO=01:CO=30:X$="BATCH EDIT"
CALL QPRINT (X$,RO,CO)
RO=02:CO=23:X$="ver 1.1  December 7, 1985"
CALL QPRINT (X$,RO,CO)
RO=04:CO=03:X$="Copyright (c) 1985  Ken Goosens, 5020 Portsmouth Road, Fairfax, VA 22032"
CALL QPRINT (X$,RO,CO)
RO=07:CO=02:X$="You are granted a limited license to use and distribute this program provided"
CALL QPRINT (X$,RO,CO)
RO=09:CO=15:X$="1.  you do not alter or remove this notice"
CALL QPRINT (X$,RO,CO)
RO=11:CO=15:X$="2.  you receive no fee or charge for this program"
CALL QPRINT (X$,RO,CO)
RO=13:CO=15:X$="3.  you assume all liability for using this program"
CALL QPRINT (X$,RO,CO)
CALL WAITSECORKEY (SEC)

END SUB

SUB INITIALIZE (NUMFLDS%,YNVAL$(1),ROW%(1),COL%(1),PROMPT$(1),_
                FLDSIZE%(1),FLDTYPE$(1),FLDVAL$(1),HLP$(1)) STATIC

REM READS IN A TABLE DEFINING SCREEN AND FIELDS 
REM PASS NUMFLD% - Number of fields to print on screen
REM YNVAL$    - Whether field preceded by Y/N field
REM ROW%      - Row where field prompt is on screen
REM COL%      - Column on screen where field prompt begins
REM PROMPT$   - Field prompt
REM FLDSIZE%  - Size of input field to right of prompt
REM FLDTYPE$  - Type of field - L = LABEL, no field inputted
REM                           - N = natural number (0,1,2,3,...)
REM                           - S = variable length string
REM FLDVAL$   - Default field value - displayed, retained if press <rtn>
REM HLP$      - Explanation of field displayed on bottom of screen

DEFINT A-Z
FOR I=1 TO NUMFLDS%
  READ YNVAL$(I),ROW%(I),COL%(I),PROMPT$(I),FLDSIZE%(I),_
                FLDTYPE$(I),FLDVAL$(I),HLP$(I)
NEXT

DATA  ,01,23,B A T C H   E D I T O R       Ver 1.1,00,L,   ,
DATA  ,03,02,"READ:"                              ,33,S,   ,"Name of file that is to be changed (e.g. TEST.DAT)"
DATA  ,03,42,"WRITE:"                             ,30,S,   ,"Name of file to write changed lines to (e.g. TEST.EDI)"
DATA  ,04,02,"Save specs in:"                     ,24,S,   ,"File to save these editing specifications in (e.g. TEST.SPC)"
DATA  ,05,48,EXCLUDE LINES                        ,00,L,   ,
DATA N,07,44,With a length less than              ,10,N,1  ,"Drop lines shorter than a minimum (e.g. empty lines)"
DATA N,08,44,"With a word in:"                    ,20,S,   ,"Drop lines containing any line in file (e.g. headers with 'PAGE')"
DATA N,09,44,With a length greater than           ,05,N,999,"Drop lines longer than a maximum"
DATA N,10,44,"Save lines in:"                     ,21,S,   ,"Put excluded lines in a file so can review (e.g. TEST.EXC)"
DATA  ,06,08,REPLACE                              ,00,L,   ,
DATA N,08,04,Convert to upper case                ,00, ,   ,"Change all characters to upper case [abc...z -> ABC...Z]"
DATA N,09,04,"Global srch/rep in:"                ,15,S,   ,"File of words with substitutes: <old>,<new>  e.g. 'Dec 85' -> 'Jan 86' "
DATA N,10,04,"Delete these chars:"                ,16,S,   ,"Omit all instances of all these characters"
DATA N,11,04,"Translate from:"                    ,17,S,$  ,"Characters to be individually replaced (e.g. $ %)"
DATA  ,12,04,"            to:"                    ,17,S," ","Replacement characters for above (e.g. blank for $,%)"
DATA  ,14,08,FIX LINE LENGTH                      ,00,L,   ,
DATA N,16,04,Pad/blanks lines shorter than        ,05,N,1  ,"Set minimum length for output, right fill blanks"
DATA  ,18,08,"EDIT NUMBERS [commas, () ]"         ,00,L,   ,
DATA N,20,04,Convert parentheses to minus sign    ,00, ,   ,"Convert # in parentheses to negative (e.g. '(378.56)' -> '-378.56 ')"
DATA N,21,04,Omit commas                          ,00, ,   ,"Remove commas inside numbers (e.g. 1,800,412.5 -> 1800412.5)"
DATA N,22,04,"..right delimited?"                 ,00, ,   ,"Do numbers end on right with a non-numeric character? (e.g. 12 285.4VA)"
DATA  ,23,04,"..Maximum # decimals:"              ,02,N,0  ,"Maximum # digits after decimal point (e.g. 17.125 has 3)"
DATA  ,12,48,"EDIT DATES (omit sep,reorder)"      ,00,L,   ,
DATA  ,14,44,"# digits in input year:"            ,01,N,2  ,"In data to edit, # digits in year (e.g. 86 is 2, 1986 is 4)"
DATA  ,15,44,"# digits in output year:"           ,01,N,2  ,"# digits you want written out for a year (1986 is all 4, 86 is last 2)"
DATA  ,16,44,"Separator btw Day,Month,Year:"      ,01,S,-  ,"In data to edit, what is btw M,D,Y (e.g. for '12/24/86' is '/')"
DATA N,17,44,Edit date with spelled month         ,00, ,   ,"Edit date where month is first 3 letters (e.g. '11-Oct-86')"
DATA  ,18,44,"..Input date format:"               ,03,S,DMY,"In incoming data to edit, order of Day,Month,Year (e.g. 11-Feb-86 is DMY)"
DATA  ,19,44,"..Output date format:"              ,03,S,YMD,"Desired order of output (e.g. YMD takes '11-Feb-86' to 860211)"
DATA N,20,44,Edit numeric dates                   ,00, ,   ,"Edit dates where numbers used for D,M,Y (e.g. 10-24-86)"
DATA  ,21,44,"..Input date format:"               ,03,S,MDY,"In incoming data to edit, order of Day,Month,Year (e.g. 10-24-86 is MDY)"
DATA  ,22,44,"..Output date format:"              ,03,S,YMD,"Desired order of date in output (e.g. YMD is 861024)"

END SUB

SUB PRTSCRN (NUMFLDS%,YNVAL$(1),ROW%(1),COL%(1),PROMPT$(1),FLDSIZE%(1),_
                FLDTYPE$(1),FLDVAL$(1),HLP$(1)) STATIC

REM PRINTS TABLE DRIVEN SCREEN

DEFINT A-Z
CLS
FOR I=1 TO NUMFLDS%
  IF YNVAL$(I)<>"" THEN_
      CO% = COL%(I)-3:_
      CALL QPRINT (YNVAL$(I),ROW%(I),CO%)
  CALL QPRINT (PROMPT$(I),ROW%(I),COL%(I))
  X% = COL%(I)+LEN(PROMPT$(I))+1
  CALL ECHO (FLDVAL$(I),ROW%(I),X%,FLDSIZE%(I))
NEXT I

END SUB

SUB GETSCRN (NUMFLDS%,YNVAL$(1),ROW%(1),COL%(1),PROMPT$(1),FLDSIZE%(1),_
                FLDTYPE$(1),FLDVAL$(1),HLP$(1)) STATIC

REM DOES FULL SCREEN DATA ENTRY FOR TABLE DRIVEN SCREEN

NUL$ = ""
TOPGETSCRN:
  FOR I=1 TO NUMFLDS%
    C% = COL%(I) - 3
    CALL EXPLAIN (HLP$(I))
    IF YNVAL$(I) <> "" THEN CALL GETCHAR (ROW%(I),C%,NUL$,VLDANS$,YNVAL$(I))
    X = INSTR("LSN",FLDTYPE$(I))
    IF X > 1 AND YNVAL$(I)<>"N" THEN_
      IF X = 2 THEN_
         CALL GETSTR (ROW%(I),COL%(I),PROMPT$(I),FLDSIZE%(I),FLDVAL$(I))_
      ELSE_
         CALL GETNATNUM (ROW%(I),COL%(I),PROMPT$(I),FLDSIZE%(I),FLDVAL$(I))
  NEXT I
  CALL UPCASE (FLDVAL$(2))
  CALL UPCASE (FLDVAL$(3))
  IF FLDVAL$(3)=FLDVAL$(2) AND FLDVAL$(2) <> "" THEN_
     X$ = "Cannot WRITE to same file READING!":_
     CALL EXPERR (X$):_
     GOTO TOPGETSCRN
  CALL UPCASE (FLDVAL$(28))
  CALL UPCASE (FLDVAL$(29))
  CALL UPCASE (FLDVAL$(31))
  CALL UPCASE (FLDVAL$(32))
END SUB


SUB FIXLEN (L$,MINLEN%,FILLER$) STATIC

REM FILLS STRNG$ WITH FILLER$ UP TO LENGTH OF MINLEN%

DEFINT A-Z
X = LEN(L$)
IF X < MINLEN% THEN L$ = L$+ STRING$(MINLEN%-X,FILLER$)

END SUB

SUB SPELLDATE (L$,DSEP$,INLEN%(1),OUTYRLEN%,TINLEN%,TOUTLEN%,NINFLDS%,_
             NOUTFLDS%,YPOS%,MONPOS%,OUTORD%(1),FILLER$) STATIC

REM CONVERTS DATES WHERE MONTH IS SPELLED BY FIRST THREE LETTERS
REM OF MONTH.  REMOVES SEPARATOR BETWEEN DATE FIELDS
REM   (DAY,MONTH,YEAR).  REARRANGES OR OMITS DATE FIELDS.  ALTERS
REM   LENGTH OF YEAR FIELD.  PRESERVES ORIGINAL LENGTH OF DATE 
REM   FIELD BY PADDING TO RIGHT UNLESS MUST EXTEND FIELD SIZE

REM PASS L$        - LINE TO EDIT
REM      DSEP$     - SEPARATOR BETWEEN DATE FIELDS
REM      INLEN%    - LENGTH OF EACH INPUT FIELD IN DATE
REM      OUTYRLEN% - LENGTH OF YEAR OUTPUT FIELD
REM      TINLEN%   - TOTAL LENGTH OF INPUT DATE
REM      TOUTLEN%  - TOTAL LENGTH OF OUTPUT DATE
REM      NINFLDS%  - NUMBER OF INPUT FIELDS IN DATE
REM      NOUTFLDS% - NUMBER OF OUTPUT FIELDS (PARTS OF DATE)
REM      YPOS%     - WHICH INPUT POSITION IS YEAR
REM      MONPOS%   - WHICH INPUT POSITION IS MONTH
REM      OUTORD%   - ORDER OF OUTPUT (WHAT INPUT POS IS 1ST,2ND,...)
REM      FILLER$   - CHARACTERS TO PAD DATE FIELD TO RIGHT IF OUTPUT IS
REM                     SHORTER THAN INPUT
REM GET  L$        - EDITED LINE

DEFINT A-Z
DIM D.FIELD$(3)

INCOLD = TINLEN%  - INLEN%(1)
INCREP = TOUTLEN% - INLEN%(1)

BS = INSTR (L$,DSEP$)
WHILE BS > 0
   INC = 1
   BPOS = BS - INLEN(1)
   IF BPOS < 1 THEN GOTO GETOUTSPDATE
   I = 1
   SPCHKFLD:
     D.FIELD$(I) = MID$(L$,BPOS,INLEN%(I))
     IF LEN(D.FIELD$(I)) < INLEN%(I) THEN GOTO GETOUTSPDATE
     IF I<>MONPOS% THEN_
        CALL NUMERIC (D.FIELD$(I),CHKNUM%)_
     ELSE_
        CALL UPCASE (D.FIELD$(I)):_
        CHKNUM% = INSTR(",JAN,FEB,MAR,APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC," , ","+D.FIELD$(I)+","):_
        IF CHKNUM% THEN_
            CHKNUM% = (CHKNUM%+4)/5:_
            D.FIELD$(I)=MID$(STR$(CHKNUM%),2):_
            IF  CHKNUM% < 10 THEN D.FIELD$(I)="0"+D.FIELD$(I)
     IF CHKNUM%=0 THEN GOTO GETOUTSPDATE
   I = I+1: IF I<=NINFLDS% THEN BPOS=BPOS+INLEN%(I-1)+1:GOTO SPCHKFLD
   IF NINFLDS% < 3 THEN_
      D.FIELD$(3)=""_
   ELSE_
      IF MID$(L$,BS+1+INLEN%(2),1) <> DSEP$ THEN_
         GOTO GETOUTSPDATE
   IF YPOS% THEN D.FIELD$(YPOS%) = RIGHT$("19"+D.FIELD$(YPOS%),OUTYRLEN%)

   X$ = ""
   FOR I=1 TO NOUTFLDS%
     X$ = X$ + D.FIELD$(OUTORD%(I))
   NEXT
   INC = INCREP
   L$ = MID$(L$,1,BS-INLEN%(1)-1)+X$+FILLER$+MID$(L$,BS+INCOLD)

GETOUTSPDATE:
   BS = BS + INC
   BS = INSTR(BS,L$,DSEP$)
WEND

END SUB

SUB NUMDATE (L$,DSEP$,INLEN%(1),OUTYRLEN%,TINLEN%,TOUTLEN%,NINFLDS%,_
             NOUTFLDS%,YPOS%,OUTORD%(1),FILLER$) STATIC

REM CONVERTS NUMERIC DATES.  REMOVES SEPARATOR BETWEEN DATE FIELDS
REM   (DAY,MONTH,YEAR).  REARRANGES OR OMITS DATE FIELDS.  ALTERS
REM   LENGTH OF YEAR FIELD.  PRESERVES ORIGINAL LENGTH OF DATE 
REM   FIELD BY PADDING TO RIGHT UNLESS MUST EXTEND FIELD SIZE

REM PASS L$        - LINE TO EDIT
REM      DSEP$     - SEPARATOR BETWEEN DATE FIELDS
REM      INLEN%    - LENGTH OF EACH INPUT FIELD IN DATE
REM      OUTYRLEN% - LENGTH OF YEAR OUTPUT FIELD
REM      TINLEN%   - TOTAL LENGTH OF INPUT DATE
REM      TOUTLEN%  - TOTAL LENGTH OF OUTPUT DATE
REM      NINFLDS%  - NUMBER OF INPUT FIELDS IN DATE
REM      NOUTFLDS% - NUMBER OF OUTPUT FIELDS (PARTS OF DATE)
REM      YPOS%     - WHICH INPUT POSITION IS YEAR
REM      OUTORD%   - ORDER OF OUTPUT (WHAT INPUT POS IS 1ST,2ND,...)
REM      FILLER$   - CHARACTERS TO PAD DATE FIELD TO RIGHT IF OUTPUT IS
REM                     SHORTER THAN INPUT
REM GET  L$        - EDITED LINE

DEFINT A-Z
DIM D.FIELD$(3)

INCOLD = TINLEN%  - INLEN%(1)
INCREP = TOUTLEN% - INLEN%(1)

BS = INSTR (L$,DSEP$)
WHILE BS > 0
   INC = 1
   BPOS = BS - INLEN(1)
   IF BPOS < 1 THEN GOTO GETOUTNUMDATE
   I = 1
   CHKFLD:
     D.FIELD$(I) = MID$(L$,BPOS,INLEN%(I))
     IF LEN(D.FIELD$(I)) < INLEN%(I) THEN GOTO GETOUTNUMDATE
     CALL NUMERIC (D.FIELD$(I),NATNUM%)
     IF NOT NATNUM% THEN GOTO GETOUTNUMDATE
   I = I+1: IF I<=NINFLDS% THEN BPOS=BPOS+INLEN%(I-1)+1:GOTO CHKFLD
   IF NINFLDS% < 3 THEN_
      D.FIELD$(3)=""_
   ELSE_
      IF MID$(L$,BS+1+INLEN%(2),1) <> DSEP$ THEN_
         GOTO GETOUTNUMDATE
   IF YPOS% THEN D.FIELD$(YPOS%) = RIGHT$("19"+D.FIELD$(YPOS%),OUTYRLEN%)
   X$ = ""
   FOR I=1 TO NOUTFLDS%
     X$ = X$ + D.FIELD$(OUTORD%(I))
   NEXT
   INC = INCREP
   L$ = MID$(L$,1,BS-INLEN%(1)-1)+X$+FILLER$+MID$(L$,BS+INCOLD)

GETOUTNUMDATE:
   BS = BS + INC
   BS = INSTR(BS,L$,DSEP$)
WEND

END SUB

SUB INITDATE (SPELLED%,INFMT$,OUTFMT$,INYRLEN%,OUTYRLEN%,INLEN%(1),_
              OUTORD%(1),YPOS%,MONPOS%,TOUTLEN%,TINLEN%) STATIC

REM INITIALIZES DATE PROCESSING PARAMETERS BASED ON DATE SPECIFICIATIONS

REM PASS INFMT$    - FORMAT OF INPUT
REM      OUTFMT$   - FORMAT OF OUTPUT
REM      INYRLEN%  - LENGTH OF INPUT YEAR
REM      OUTYRLEN% - LENGTH OF OUTPUT YEAR
REM GET  INLEN%    - LENGTH OF EACH FIELD IN INPUT DATE
REM      OUTORD%   - OUTPUT ORDER (WHAT FIELD IN INPUT IS 1ST,2ND,...)
REM      YPOS%     - POSITION IN INPUT OF YEAR FIELD
REM      TOUTLEN%  - TOTAL LENGTH OF DATE OUTPUT FIELD
REM      TINLEN%   - TOTAL LENGTH OF  DATE INPUT FIELD

DEFINT A-Z

YPOS% = 0
TINLEN% = 0
TOUTLEN% = 0
FOR I=1 TO 3
  INLEN%(I) = 0
NEXT I

FOR I=1 TO LEN(INFMT$)
  D2D = INSTR(OUTFMT$,MID$(INFMT$,I,1))
  IF MID$(INFMT$,I,1)="Y" THEN_
     YPOS% = I:_
     INLEN%(I) = INYRLEN%_
  ELSE_
     IF MID$(INFMT$,I,1)="M" THEN_
         MONPOS% = I:_
         INLEN%(I) = 2 - SPELLED_
     ELSE_
         INLEN%(I) = 2

  OUTLEN = 0
  IF D2D > 0 THEN_
     OUTORD%(D2D) = I:_
     IF MID$(OUTFMT$,D2D,1)="Y" THEN_
       OUTLEN = OUTYRLEN%_
     ELSE_
       OUTLEN = 2
  TOUTLEN% = TOUTLEN% + OUTLEN
  TINLEN%  = TINLEN%  + INLEN%(I)
NEXT I
TINLEN% = TINLEN% + LEN(INFMT$) - 1

END SUB

SUB DELCOMMAS (L$,RIGHT.DELIMITED%,MAXDEC%) STATIC

REM DELETES COMMAS INSIDE A NUMBER

REM SEND L$               - STRING TO BE EDITED
REM      RIGHT.DELIMITED% - WHETHER NUMBER HAS NON-NUMERIC CHAR
REM                           TO ITS RIGHT (E.G. SPACE)
REM      MAXDEC%          - MAXIMUM NUMBER OF DECIMAL PLACES
REM GET  L$

DEFINT A-Z

COM$ = ","
PREV.BS = 0
BS = INSTR(L$,COM$)
WHILE BS > 0
   IF BS < 1 THEN_
      Y$="!"_
   ELSE_
      Y$ = MID$(L$,BS-1,1)
   CALL NUMERIC (Y$,FRONT%)
   IF NOT FRONT% THEN_
      BS=BS + 1:_
      GOTO NXTPRT 
   STARTPOS = BS-1
   STOPPOS = BS-4
   IF STOPPOS < PREV.BS THEN STOPPOS = PREV.BS
   IF STARTPOS > 1 THEN_
     X$ = MID$(L$,STARTPOS-1,1):_
     WHILE X$ <> "" AND X$ <> "-" AND X$ <> "+" AND INSTR("0123456789",X$) AND STARTPOS > STOPPOS AND STARTPOS > 1:_
        STARTPOS = STARTPOS - 1:_
        X$ = MID$(L$,STARTPOS-1,1):_
     WEND
   IF X$ = "-" OR X$ = "+" THEN_
      STARTPOS = STARTPOS - 1
   BACK%=-1
   WHILE  MID$(L$,BS,1) = COM$ AND BACK%
     X$=MID$(L$,BS+1,3)
     IF LEN(X$)<3 THEN_
         BACK%=0_
     ELSE_
         CALL NUMERIC(X$,BACK%)
     IF STARTPOS < 1 THEN STARTPOS = 1
     BS = BS + 1 - (BACK% * 3)
   WEND
   IF BS-STARTPOS < 5 THEN GOTO NXTPRT
   IF MID$(L$,BS,1) = "." THEN_
      BS = BS+1:_
      NDEC = 0:_
      WHILE INSTR("0123456789",MID$(L$,BS,1)) AND NDEC < MAXDEC%:_
        BS = BS + 1:_
        NDEC = NDEC + 1:_
      WEND
   X$ = MID$(L$,STARTPOS,BS-STARTPOS)
   L = LEN(X$)

   IF L < 5 THEN GOTO NXTPRT
   CALL REMOVE (X$,COM$)
   FIL$ = SPACE$(L-LEN(X$))
   IF RIGHT.DELIMITED% OR MAXDEC% < 1 THEN_
      X$ = X$ + FIL$_
   ELSE_
      X$ = FIL$ + X$
   MID$(L$,STARTPOS,L) = X$
NXTPRT:
   PREV.BS = BS
   BS=INSTR(BS,L$,COM$)
WEND

END SUB

SUB GETSTR (ROW%,COL%,PROMPT$,FLDSIZE%,RESULT$) STATIC

REM INPUT ROUTINE TO GET A STRING
REM LOCATE 24,70:PRINT "GETSTR  ";

X% = FLDSIZE%+1:IF X%<8 THEN X%=8
CALL QPRINT (PROMPT$+SPACE$(X%),ROW%,COL%)
X% = COL% + LEN(PROMPT$) + 1
CALL ECHO (RESULT$,ROW%,X%,FLDSIZE%)
LOCATE ROW%,X%
INPUT "",X$
IF X$ <> "" THEN RESULT$ = X$:CALL ECHO (RESULT$,ROW%,X%,FLDSIZE%)

END SUB

SUB GETCHAR (ROW%,COL%,PROMPT$,VLDANS$,RESULT$) STATIC

REM ROUTINE TO GET SINGLE CHARACTER

DEFINT A-Z
CR$ = CHR$(13)
FLDSIZE% = 1
CALL QPRINT (PROMPT$+RESULT$,ROW%,COL%)
X% = COL% + LEN(PROMPT$)
LOCATE ROW%,X%,1,6,7
X$ = INPUT$(1)
IF X$ = CR$ THEN X$ = RESULT$:IF X$="" THEN X$=CHR$(0)
CALL UPCASE (X$)
IF VLDANS$ <> "" THEN_
    WHILE INSTR(VLDANS$,X$)=0:_
      BEEP:_
      X$ = INPUT$(1):CALL UPCASE (X$):_
    WEND
RESULT$ = X$:PRINT RESULT$;

END SUB

SUB GETNATNUM (ROW%,COL%,PROMPT$,FLDSIZE%,RESULT$) STATIC

REM ROUTINE TO INPUT ONLY NATURAL NUMBER (> OR = 0)
REM LOCATE 24,70:PRINT "GETNATNUM ";

DEFINT A-Z
RESTART:
  CALL GETSTR (ROW%,COL%,PROMPT$,FLDSIZE%,RESULT$)
  CALL NUMERIC (RESULT$,NONNEG%)
IF NOT NONNEG% THEN BEEP:GOTO RESTART

END SUB

SUB ECHO (STRNG$,ROW%,COL%,FLDSIZE%) STATIC

REM ROUTINE FOR CLEARING A SPACE AND PRINTING MESSAGE

CALL QPRINT (SPACE$(FLDSIZE%),ROW%,COL%)
CALL QPRINT (STRNG$,ROW%,COL%)

END SUB

SUB TRIM (STRNG$) STATIC

REM REMOVES LEADING AND TRAILING BLANKS FROM STRNG$

DEFINT A-Z
ONE = 1
CALL FIRSTNB (STRNG$,ONE,STRT)
IF STRT < 1 THEN_
   STRT = 1:LST = 0_
ELSE_
   X$ = "!"+STRNG$:_
   LST = LEN(X$):_
   WHILE MID$(X$,LST,1)=" ":_
     LST = LST-1:_
   WEND:_
   LST = LST - 1
STRNG$ = MID$(STRNG$,STRT,LST-STRT+1)

END SUB

SUB BRKWORDS (STRNG$,WORDS$(1)) STATIC

REM PASS STRNG$  - A STRING TO BE BROKEN INTO WORDS (SPACE
REM                 DELIMITED STRINGS)
REM      WORDS$  - AN ARRAY TO PUT WORDS IN

DEFINT A-Z
ONE = 1
LST = LEN(STRNG$)
X$ = STRNG$ + " !"
CALL FIRSTNB(X$,ONE,BS)
NPARMS = 0
MAXPARMS = UBOUND(WORDS$)
WHILE BS <= LST
  NPARMS = NPARMS + 1
  CALL LASTNB (X$,BS,ES)
  IF NPARMS > MAXPARMS THEN _
     BS = LST+1_
  ELSE_
     WORDS$(NPARMS) = MID$(X$,BS,ES-BS+1):_
     BS = ES+1:_
     CALL FIRSTNB(X$,BS,BS)
WEND
END SUB

SUB FIRSTNB (STRNG$,BEG%,WHEREIS%) STATIC

REM PASS STRNG$  - A STRING TO BE SEARCHED
REM      BEG%     - POSITION TO BEGIN SEARCH
REM GET  WHEREIS% - POSITION IN STRNG$ OF FIRST NON-BLANK AT
REM                  BEG% OR LATER.  RETURNS 0 IF NO NON-BLANK.

DEFINT A-Z
REM LOCATE 24,70:PRINT "FIRSTNB  ";
X$ = STRNG$+"!"
WHEREIS% = BEG%
IF WHEREIS% < 1 THEN WHEREIS% = 1
WHILE MID$(X$,WHEREIS%,1) = " "
   WHEREIS% = WHEREIS% + 1
WEND
IF WHEREIS% > LEN(STRNG$) THEN WHEREIS% = 0

END SUB

SUB LASTNB (STRNG$,BEG%,WHEREIS%) STATIC

REM PASS STRNG$   - A STRING TO BE SEARCHED
REM      BEG%      - POSITION TO BEGIN SEARCH
REM GET  WHEREIS%  - LAST POSITION IN STRNG$ OF ANY WORD BEGINNING AT
REM                   BEG% OR LATER.  RETURNS BEG%-1 IF NO WORD AT BEG%.

DEFINT A-Z
REM LOCATE 24,70:PRINT "LASTNB  ";
B = BEG
IF B < 1 THEN B = 1
IF B > LEN(STRNG$) THEN_
   X$ = " " _
ELSE_
   X$ = MID$(STRNG$,B)+" "
WHEREIS% = INSTR(X$," ") - 1 + B - 1

END SUB

SUB REPPARENS(L$) STATIC

REM MAKES NUMBERS ENCLOSED IN PARENTHESES NEGATIVE.
REM   ADDS NEGATIVE SIGN TO FRONT, REMOVES TRAILING AND LEADING
REM BLANKS, LEFT JUSTIFIES NUMBER, PRESERVES FIELD LENGTH BY
REM FILLING WITH BLANKS TO RIGHT.

BS=1
BLNK$=" "
LPAREN$="("
RPAREN$=")"
BS=INSTR(BS,L$,LPAREN$)
ES=INSTR(BS + 1,L$,RPAREN$)
WHILE ES > BS
   L = ES-BS-1
   X$=MID$(L$,BS + 1,L)
   CALL REALNUM (X$,NONNEG%)
   IF NONNEG% THEN_
      CALL REMOVE (X$,BLNK$):_
      L = L+2:_
      MID$(L$,BS,L) = "-" + X$ + SPACE$(L-1-LEN(X$))
   BS=ES + 1
   BS=INSTR(BS,L$,LPAREN$)
   IF BS > 0 THEN_
     ES=INSTR(BS + 1,L$,RPAREN$)_
   ELSE_
     ES=0   
WEND
END SUB

SUB REALNUM (STRNG$,RESULT%) STATIC

REM CHECKS WHETHER STRNG$ IS A VALID REAL NUMBER
REM PASS STRNG$  - STRING TO BE CHECKED
REM GET  RESULT% - TRUE IF REAL

DEFINT A-Z
X$ = STRNG$+"."
LENGTH = LEN(STRNG$)
J=1
WHILE INSTR("+- ",MID$(X$,J,1))
  J=J+1
WEND
IF J > LENGTH THEN RESULT% = 0:EXIT SUB

X = INSTR(X$,".")
FRONT$ = MID$(STRNG$,J,X-J)
IF X > LENGTH THEN_
   BACK$=""_
ELSE_
   BACK$  = MID$(STRNG$,X+1)

CALL NUMERIC (FRONT$,FRNNAT%)
CALL NUMERIC (BACK$,BNNAT%)
RESULT% = (FRNNAT% AND BNNAT%)

END SUB

SUB NUMERIC (STRNG$,RESULT%) STATIC

REM PASS STRNG$  - A STRING TO BE SEARCHED
REM GET  RESULT%  - TRUE IF STRNG$ CONTAINS ONLY NON-NEGATIVE DIGITS 
REM                  OR LEADING OR TRAILING BLANKS

DEFINT A-Z
IF STRNG$=SPACE$(LEN(STRNG$)) THEN RESULT%=0:GOTO GETOUTNUMERIC
NUM$="0123456789"
CALL NOOTHER (STRNG$,NUM$,RESULT%)
GETOUTNUMERIC:
END SUB

SUB NOOTHER (STRNG$,ONLY$,RESULT%) STATIC

REM PASS STRNG$  - A STRING TO BE SEARCHED
REM      ONLY$   - A LIST OF THE ONLY CHARACTERS TO BE IN STRNG$
REM GET  RESULT%  - TRUE OF ONLY CHARACTERS IN STRNG$ ARE THOSE IN ONLY$
REM                   OR ARE LEADING OR TRAILING BLANKS

DEFINT A-Z

RESULT% = -1
IF LEN(STRNG$) < 1 THEN GOTO GETOUTNOOTHER
ONE = 1
CALL FIRSTNB(STRNG$,ONE,BS)
CALL LASTNB(STRNG$,BS,ES)

FOR I=BS TO ES
   IF INSTR(ONLY$,MID$(STRNG$,I,1)) = 0 THEN_
      RESULT% = 0:_
      I=ES+1
NEXT I

IF STRNG$ <> MID$(STRNG$,1,ES)+SPACE$(LEN(STRNG$)-ES) THEN RESULT% = 0

GETOUTNOOTHER:
END SUB

SUB GLOBAL(L$,OLDS$(1),NEWS$(1)) STATIC

REM GLOBAL SEARCH AND REPLACE
REM PASS L$     - STRING TO SEARCH AND REPLACE
REM      OLDS$  - WHAT SEARCHING FOR AND REPLACING
REM      NEWS$  - WHAT REPLACING BY
REM NOTE: ASSUME OLD AND NEW ARE ARRAYS FULL OF WHAT LOOKING FOR

DEFINT A-Z
FOR I=1 TO UBOUND(OLDS$)
   CALL REPLACE(L$,OLDS$(I),NEWS$(I))
NEXT I
END SUB

SUB REPLACE (L$,OLD$,NEW$) STATIC

REM GLOBAL SEARCH FOR OLD$, REPLACE BY NEW$, IN L$

DEFINT A-Z
OLDLEN=LEN(OLD$)
IF OLDLEN <1 THEN GOTO GETOUTREPLACE
NEWLEN=LEN(NEW$)
BS=1
ES=INSTR(BS,L$,OLD$)
WHILE ES <> 0
   BS=ES + OLDLEN
   L$=MID$(L$,1,ES-1) + NEW$ + MID$(L$,BS)
   BS=ES + NEWLEN
   ES=INSTR(BS,L$,OLD$)
WEND
GETOUTREPLACE:
END SUB

SUB REMOVE (L$,BADSTRNG$) STATIC

REM REMOVES FROM L$ ALL INSTANCES OF CHARACTERS IN BADSTRNG$

REM PASS L$        - STRING TO BE ALTERED
REM      BADSTRNG$ - LIST OF CHARACTERS TO REMOVE
REM GET  L$        - ORIGINAL MINUS BADSTRNG$

DEFINT A-Z
J = 0
FOR I=1 TO LEN(L$)
  IF INSTR(BADSTRNG$,MID$(L$,I,1)) = 0 THEN_
     J = J+1:_
     MID$(L$,J,1) = MID$(L$,I,1)
NEXT I
L$ = LEFT$(L$,J)

END SUB

SUB KEEPONLY (L$,GOODSTRNG$) STATIC

REM KEEPS IN L$ ONLY THOSE CHARACTERS IN GOODSTRNG$, I.E.
REM     REMOVES FROM L$ ALL INSTANCES OF CHARACTERS NOT IN GOODSTRNG$

REM PASS L$         - STRING TO BE ALTERED
REM      GOODSTRNG$ - LIST OF CHARACTERS TO KEEP
REM GET  L$         - ORIGINAL MINUS CHARS NOT IN GOODSTRNG$

DEFINT A-Z
J = 0
FOR I=1 TO LEN(L$)
  IF INSTR(GOODSTRNG$,MID$(L$,I,1)) THEN_
     J = J+1:_
     MID$(L$,J,1) = MID$(L$,I,1)
NEXT I
L$ = LEFT$(L$,J)

END SUB

SUB TRANSLATE (L$,GOT$,WANT$) STATIC

REM REPLACES IN L$ ALL INSTANCES OF CHARACTER IN GOT$ BY CORRESPONDING
REM   CHARACTER IN WANT$

REM PASS L$     - STRING TO BE ALTERED
REM      GOT$   - LIST OF CHARACTERS WANTED REPLACED
REM      WANT$  - WHAT REPLACE BY
REM GET  L$     - ALTERED STRING

DEFINT A-Z
FOR I=1 TO LEN(L$)
  PO = INSTR(GOT$,MID$(L$,I,1))
  IF PO THEN MID$(L$,I,1) = MID$(WANT$,PO,1)
NEXT I

END SUB

SUB EXPERR (STRNG$) STATIC

REM EXPLAIN AN ERROR

DEFINT A-Z
BEEP

CALL EXPLAIN (STRNG$)
SEC = 3
CALL WAITSECORKEY (SEC)
BEEP

END SUB

SUB EXPLAIN (STRNG$) STATIC

REM CONTROLS MESSAGE IN INVERSE VIDEO ON LINE 24

DEFINT A-Z
RO = 24
CO = 3
PGE = 0
ATTR = (7 AND 7)*16
X$ = LEFT$(STRNG$,75)
CALL XQPRINT (" "+X$+SPACE$(75-LEN(X$)),RO,CO,ATTR,PGE)
COLOR 7,0

END SUB

SUB WAITSECORKEY (SECONDS%) STATIC

REM PAUSE ROUTINE BASED ON CLOCK
REM SEND SECONDS% - MAXIMUM # SECONDS TO WAIT
REM WILL QUIT IF ANY KEY PRESSED

CURSEC! = (val(mid$(time$,4,2))*60+val(mid$(time$,7,2)))
DONE!   = CURSEC! + SECONDS%
WHILE CURSEC! < DONE! AND INKEY$ = ""
   CURSEC! = (val(mid$(time$,4,2))*60+val(mid$(time$,7,2)))
WEND

END SUB

