	PAGE	60,132
	TITLE	CD! 1.2 replacement for DOS CD command sets ERRORLEVEL
		; 1996 October 25
Comment 

Ŀ
 CD! C:\MySub\MySub2 
 CD! C:\MySub\       
 CD! C:MySub	      
 CD! ..	      
 CD! D:\	      
 CD! D:	      
 CD! \ 	      
 CD!		      
    ^watch the space 


Written in Microsoft Assembler MASM 5.0

by Roedy Green
Canadian Mind Products
POB 707 Quathiaski Cove
Quadra Island BC Canada
V0P 1N0
(250) 285-2954
Internet Roedy@Bix.Com

This program is copyrighted but free.  The source and object
code may be used for any purpose except military.  You are free
to copy it, sell it, modify it, or cannibalize it.  You can take
out the credits if you want.  The only restriction, backed up by
Canadian Mind Products standard very nasty penalties is that you
must make sure none of it is ever used for a military purpose.

Version History:
================
Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 1993 June 7
- embed new address and phone

Version 1.0 1988 April 29

Purpose
=======

The CD command that comes with MS or PC DOS has three flaws:
1.  It does not set the ERRORLEVEL for Invalid directories.
2.  It fails when there is a trailing backslash on the name.
3.  You cannot hide its error messages with >NUL: redirection.


CD! acts just like CD except that it fixes these three problems.
CD! is slower since it is must be loaded each time, whereas CD
is internal to DOS.

Samples of Use
==============

CD! behaves just like the normal DOS CD command except that it
sets ERRORLEVEL to 1 if it fails because the directory requested
does not exist.

CD! C:\MYDIR\MYSUBDIR
IF ERRORLEVEL 1 ECHO missing directory

CD \MYDIR
CD! SUBDIR
IF ERRORLEVEL 1 ECHO missing directory

CD! \MYDIR\MYSUBDIR\
IF ERRORLEVEL 1 ECHO missing directory

CD! ..
IF ERRORLEVEL 1 ECHO already at the root

CD! D:\
REM changes the current directory on D: to the root

CD! D:
REM displays the current directory on D:

CD!
REM displays the current directory.

Notes on How CD! Works
======================

CD! parses the command line looking for a subdirectory name.

If there is no command line, we display the current directory
on the current drive using DOS function 47h.  In order to
display the current drive, we uses DOS function 19h.

If there is simply a C: or D: we display the current directory
on the requested drive using DOS function 47h.

If we find a full directory name e.g. XXX or  C:\MYSUB or C:\ we
uses DOS function 3BH to attempt to change the current
directory.

If the command succeeds we exit with errorlevel = 0.

If it fails we exit with errorlevel = 1.

 ; End of long comment

; M A C R O S

CR	MACRO	; Carriage return line feed
	DB 0dh,0ah
	ENDM

;======

EOS	MACRO	; marks end of display string
	DB 0dh,0ah,'$'
	ENDM

;======

CODE	SEGMENT PARA

	ASSUME	CS:CODE,DS:CODE,ES:CODE
	ORG	100H

;======================================

Start:	JMP	Main
;======================================
;	REGISTER CONVENTIONS
;	all registers are trashable in calls except BX and CX
;	BX always points to the start of the command string.
;	CX always counts number of chars in the command string
;	exclusive of nulls, leading and trailing blanks.
;	Because this is a com file, all segment registers are
;	stable equal to CS:
;======================================
SAY	MACRO	Msg
;	display message on screen
	LEA	DX,&Msg 	; use LEA rather than
				; MOV Offset for more generality
	MOV	AH,09h
	INT	21h
	ENDM

;======================================
Current DB	65d DUP (0)	; work area
				; for current directory name
				; THIS IS NOT THE SAME AS THE
				; COMMAND LINE.
;======================================
NoSuchDirMsg	LABEL	BYTE
	DB	'Invalid directory',"$"

ColonSlashMsg	LABEL	BYTE
	DB	':\',"$"

CrLfMsg 	LABEL	BYTE
	DB	13,10,"$"
;========================================
MLeading	PROC	Near
;	on entry BX is addr of string, CX its length
;	trims off any leading blanks, leaving result in BX CX
;	length may also be 0 or 1, but not -ve
;	If the entire string is blank the result is the null string
	MOV	DI,BX
	MOV	AL,20h		; AL = blank  -- the search char
	JCXZ	MLEADING2	; jump if null string
	REPE	SCASB		; scan ES:DI forwards till hit non blank
				; DI points just after it (wrap ok)
				; CX is one too small, or 0 if none found
	JE	MLEADING1	; jump if entire string was blank
	INC	CX		; CX is length of remainder of string
MLEADING1:
	DEC	DI		; DI points to non-blank
MLEADING2:
	MOV	BX,DI		; put address back
	RET
MLeading	ENDP
;========================================
MTrailing	PROC	Near
;	on entry BX is addr of string, CX its length
;	trims off any trailing blanks, leaving result in BX CX
;	length may also be 0 or 1, but not -ve
;	If the entire string is blank the result is the null string
	MOV	DI,BX
	ADD	DI,CX		; calc addr last char in string
	DEC	DI
	MOV	AL,20h		; AL = blank  -- the search char
	JCXZ	MTRAILING1	; jump if null string
	STD
	REPE	SCASB		; scan ES:DI backwards till hit non blank
				; DI points just ahead of it (wrap ok)
				; CX is one too small, or 0 if none found
	CLD
	JE	MTRAILING1	; jump if whole string was blank
	INC	CX
MTRAILING1:
	RET
MTrailing	ENDP
;========================================;====
Parse	PROC	NEAR
;	Parse the command line to remove lead/trail blanks
;	and terminate by 2 nulls.
;	sample inputs
;	CD!	C:\MySub\MySub2\
;	CD! MySub2
;	CD!
;	CD!  D:\
;	CD!  D:
;
;	When Done DS:BX points to start of string.
;	String will be terminated by 2 nulls
;	CX counts bytes in string exclusive of nulls
				; counted string at HEX 80 PSP
				; contains command line.
				; Preceeded by unwanted spaces.
				; possibly followed by unwanted spaces.
				; currently missing a trailing null.
	XOR	CH,CH
	MOV	CL,DS:80h
	MOV	BX,81h
	CALL	Mleading	; get rid of leading blanks
	CALL	MTrailing	; get rid of trailing blanks
	MOV	DI,BX		; calc addr of byte just past end
	ADD	DI,CX
	MOV	WORD PTR [DI],0 ; plop in pair of nulls after string
	RET
Parse	ENDP
;=======================================
Analyze PROC	Near
;	On entry DS:BX points to start of string.
;	String will be terminated by nulls.
;	CX counts bytes in string exclusive of nulls.
;	We have to analyze the string and set
;	3 indicator bits in DX
;	1.  DrivePresent  0=no 4=yes
;	2.  SubdirPresent 0=no 2=yes
;	3.  SlashPresent  0=no 1=yes  - trailing slash
;	Handles case
;	  123
;	0 000  CD! __
;	1 001  CD! \__
;	2 010  CD! ABC__
;	3 011  CD! ABC\__
;	4 100  CD! C:__
;	5 101  CD! C:\__
;	6 110  CD! C:ABC__
;	7 111  CD! C:ABC\__
;	We look first for drive, then slash, finally subdir
	PUSH	BX
	PUSH	CX
	XOR	DX,DX			; build indicator in DX
	JCXZ	NoSubdir
	CMP	BYTE PTR [BX+1],':'
	JNE	NoDrive
	ADD	DX,4			; C: drive was present
	ADD	BX,2			; bypass drive
	SUB	CX,2
	JCXZ	NoSubdir
NoDrive:
	MOV	DI,BX
	ADD	DI,CX			; find end of string
	CMP	BYTE PTR [DI-1],'\'
	JNE	NoSlash
					; was trailing slash
	INC	DX
	DEC	CX			; bypass slash
NoSlash:
	JCXZ	NoSubdir		; anything left -- the subdir
	ADD	DX,2			; Was Subir
NoSubdir:
					; DX contains analysis.
	POP	CX			; restore old length
	POP	BX			; restore old start
	RET
Analyze ENDP
;=======================================
ChopSlash	PROC	Near
;	On entry DS:BX points to start of string.
;	CX counts length of string.
;	String will be terminated by a null.
;	Our job it to chop off the trailing slash by plopping a
;	null on it.  We are guaranteed it is there.
	MOV	DI,BX
	DEC	CX			; string is shorter now
	ADD	DI,CX			; point to \ at end
	MOV	BYTE PTR [DI],0 	; clobber \ with null
	RET
ChopSlash	ENDP
;=======================================
ChDir	PROC	near
;	Change directory
;	DS:BX points to ASCIIZ string name
;	Aborts with DIE and error message on failure
;	DOS wants trailing \ for root but no other directory
	MOV	DX,BX		; DS:DX points to string
	MOV	AH,3Bh
	INT	21H		; Do change directory command
	JC	ChDirFail
	RET
ChDirFail:
	SAY	NoSuchDirMsg	; Invalid directory
	SAY	CrLfMsg
	JMP	Die		; DIE with errorlevel=1
ChDir	ENDP
;=======================================
ShowDir PROC	near
;	Display current directory on given drive without leading C:\
;	DL = 0 means show directory for default drive
;	DL = 1 means show directory for drive A:
;	DL = 2 means show directory for drive B:
	PUSH	BX		; save CX:BX
	PUSH	CX
	LEA	SI,Current
	MOV	AH,47h
	INT	21h
				; result appears in Current
				; in form XXX\XXX with trailing null
				; but no lead or trailing backslash
				; If default directory is root
				; just a null.
				; Calculate its length
	MOV	CX,64d		; max poss length
	MOV	DI,SI
	MOV	AL,0
	REPNE	SCASB		; search for null
	SUB	CX,63d
	NEG	CX		; CX contains length of string
	MOV	BX,1		; prefined file handle 1 = screen
	MOV	DX,SI		; DS:DX points to Current
	MOV	AH,40H		; WRITE HANDLE
	INT	21H
				; cannot use SAY because of possible
				; embedded $ in names.
	POP	CX		; restore pointers to string
	POP	BX
	RET
ShowDir ENDP
;=======================================
ShowDefDrive	PROC	near
;	Display the default drive
;	as C:\
	MOV	AH,19h		; ask DOS what default drive is
	INT	21h
				; result it AL, 0=A 1=B
				; NOTE THIS IS NOT THE USUAL DOS
				; CONVENTION WHERE 1=A
	ADD	AL,'A'		; convert to letter
	MOV	DL,AL		; get the letter C in C:
	MOV	AH,02H		; WRITE 1 char
	INT	21h
	Say	ColonSlashMsg	; write the :\
	RET
ShowDefDrive	ENDP
;=======================================
ShowDefDir	PROC	near
;	Display the current directory on default drive
;	without leading C:\
				; ask DOS what default subdir is
				; Dos wants drive in form
				; 0=default
				; 1=A: 2=B: 3=C: etc.
	MOV	DL,0
	CALL	ShowDir
	RET
ShowDefDir	ENDP
;=======================================
ToUC	PROC	NEAR
;	converts char in AL to upper case
	CMP	AL,'a'
	JB	FineAsIs
	CMP	AL,'z'
	JA	FineAsIs
	SUB	AL,20h		; convert a to A
FineAsIs:
	RET
ToUc	ENDP
;======================================
ShowExpDrive	PROC	near
;	Display the current explicitly mentioned drive
;	as C:\
;	on entry DS:BX points to start of command string i.e. C:
	MOV	AL,BYTE PTR[BX] ; get the drive letter
	Call	ToUc		; convert to upper case
	MOV	DL,AL
	MOV	AH,02H		; WRITE 1 char
	INT	21h
	Say	ColonSlashMsg	; write the :\
	RET
ShowExpDrive	ENDP
;=======================================
ShowExpDir	PROC	near
;	Display the current directory on explicitly mentioned
;	drive on the command line e.g. CD! C:
;	without leading C:\
;	on entry DS:BX points to start of command string i.e. C:
				; ask DOS what default subdir is
				; Dos wants drive in form
				; 0=default
				; 1=A: 2=B: 3=C: etc.
	MOV	AL,BYTE PTR[BX]
	Call	ToUc
	MOV	DL,AL
				; Dos wants drive in form
				; 0=default
				; 1=A: 2=B: 3=C: etc.
	SUB	DL,'A'-1
	CALL	ShowDir
	RET
ShowExpDir	ENDP
;=======================================
Case0	PROC	Near
;	Handles case 0
;	  123
;	0 000  CD! __
	CALL	ShowDefDrive	; show current drive
	CALL	ShowDefDir	; show current directory on current drive
	SAY	CrLfMsg
	RET
Case0	ENDP
;=======================================
Case1	PROC	Near
;	Handles case 1
;	  123
;	1 001  CD! \__
	CALL	ChDir		; change directory
	RET
Case1	ENDP
;=======================================
Case2	PROC	Near
;	Handles case 2
;	  123
;	2 010  CD! ABC__
	CALL	ChDir		; change directory
	RET
Case2	ENDP
;=======================================
Case3	PROC	Near
;	Handles case 3
;	  123
;	3 011  CD! ABC\__
	CALL	ChopSlash	; get rid of trail slash
	CALL	ChDir		; change directory
	RET
Case3	ENDP
;=======================================
Case4	PROC	Near
;	Handles case 4
;	  123
;	4 100  CD! C:__
	CALL	ShowExpDrive	; show the explicitly mentioned drive
	CALL	ShowExpDir	; show current dir on explicit drive
	SAY	CrLfMsg
	RET
Case4	ENDP
;=======================================
Case5	PROC	Near
;	Handles case 5
;	  123
;	5 101  CD! C:\__
	CALL	ChDir		; change directory
	RET
Case5	ENDP
;=======================================
Case6	PROC	Near
;	Handles case 6
;	  123
;	6 110  CD! C:ABC__
	CALL	ChDir		; change directory
	RET
Case6	ENDP
;=======================================
Case7	PROC	Near
;	Handles case 7
;	  123
;	7 111  CD! C:ABC\__
	CALL	ChopSlash	; get rid of trail slash
	CALL	ChDir		; change directory
	RET
Case7	ENDP
;=======================================
Cases	PROC	Near
;	handle all cases by call Case[DX]
;	on entry DX contains case#
;	1.  DrivePresent  0=no 4=yes
;	2.  SubdirPresent 0=no 2=yes
;	3.  SlashPresent  0=no 1=yes  - trailing slash
;	Cases
;	  123
;	0 000  CD! __
;	1 001  CD! \__
;	2 010  CD! ABC__
;	3 011  CD! ABC\__
;	4 100  CD! C:__
;	5 101  CD! C:\__
;	6 110  CD! C:ABC__
;	7 111  CD! C:ABC\__
;
	MOV	SI,DX		; Call Case[DX]
	SHL	SI,1
	Call	CaseTable[SI]
	RET
CaseTable	LABEL	WORD
	DW	offset Case0
	DW	offset Case1
	DW	offset Case2
	DW	offset Case3
	DW	offset Case4
	DW	offset Case5
	DW	offset Case6
	DW	offset Case7
Cases	ENDP
;======================================
Bye	PROC	NEAR
;	Return to DOS with a final message and 0 ERRORLEVEL
	MOV	AX,4C00h	; quit with 0 errorlevel
	INT	21h
Bye	ENDP
;======================================
Die	PROC	NEAR
;	Fatal error -- give up and return to DOS with ERRORLEVEL=1
	MOV	AX,4C01h	; die with 1 errorlevel
	INT	21h
Die	ENDP
;=======================================
MAIN	PROC
	CALL	Parse		; parse command line
				; DS:BX contains ASCIIZ string
	CALL	Analyze 	; determine DX case analysis
	CALL	Cases		; handle each of the 8 cases
	JMP	Bye		; return to DOS
MAIN	ENDP
;======================================

CopyrightMsg	label byte	; does not display
	CR
	DB	' CD! 1.2 ۲'
	CR
	DB	'Freeware to change the default directory.'
	CR
	DB	'usage:  CD!  C:\Mysub1\MySub2'
	CR
	DB	'Copyright (c) 1988, 1996 Roedy Green Canadian Mind Products'
	CR
	DB	'POB 707 Quathiaski Cove, Quadra Island, BC Canada V0P 1N0',13,10
	DB	'Telephone: (250) 285-2954          Internet:roedy@bix.com',13,10
	DB	'May be freely distributed and used for any purpose except military.'
	EOS

CODE	ENDS
	END	Start
