@echo off

rem MENU.BAT to invoke programs from a menu
rem The programs in this batch are my five statistics programs, but
rem it should be easy for you to tailor this idea for your own needs.

rem If you get an "Out of environment space" message, increase your
rem environment space by using shell configuration in config.sys:
rem MsDos 3.30 example: shell=c:\bin\command.com /e:1024 /p

rem Set the appropriate program names into environment variables
set _prog1=c:\stat\statmeas.exe
set _prog2=c:\stat\statregr.exe
set _prog3=c:\stat\stattran.exe
set _prog4=c:\stat\statrcor.exe
set _prog5=c:\stat\statladr.exe

rem Check that the programs exist
set _prog=
if not exist %_prog1% set _prog=%_prog1%
if not exist %_prog2% set _prog=%_prog2%
if not exist %_prog3% set _prog=%_prog3%
if not exist %_prog4% set _prog=%_prog4%
if not exist %_prog5% set _prog=%_prog5%
if not "%_prog%"=="" goto _err1

:_begin
cls
echo [0;41;33;1m
echo Ŀ
echo  Menu for selecting and running programs           
echo  Copyright by Prof. Timo Salmi Sat 29-Dec-90       
echo  Email: ts@uwasa.fi  WWW: http://www.uwasa.fi/~ts/ 
echo 
echo [40;33;1m

rem Make a menu, liven it up with colors
echo [47;30;1m 0) exit the menu      .
echo [42;30;1m 1) %_prog1%
echo [43;33;1m 2) %_prog2%
echo [44;33;1m 3) %_prog3%
echo [45;33;1m 4) %_prog4%
echo [46;33;1m 5) %_prog5%
echo [40;33;1m

rem Check that ask.exe is available at path or the current directory
set _found=no
if exist ask.exe set _found=yes
for %%d in (%path%) do if exist %%d\ask.exe set _found=yes
if "%_found%"=="no" goto _err3

ask Select program number to run: /d
set _prog=
if errorlevel==48 if not errorlevel==49 set _prog=_exit
if errorlevel==49 if not errorlevel==50 set _prog=%_prog1%
if errorlevel==50 if not errorlevel==51 set _prog=%_prog2%
if errorlevel==51 if not errorlevel==52 set _prog=%_prog3%
if errorlevel==52 if not errorlevel==53 set _prog=%_prog4%
if errorlevel==53 if not errorlevel==54 set _prog=%_prog5%
if "%_prog%"=="_exit" goto _out
if "%_prog%"=="" goto _err2

rem Run the program
%_prog%

:_again
ask [0;45;36;1mSelect from the menu again (y/n)?[40;33;1m /u /d
if errorlevel==89 if not errorlevel==90 goto _begin
if errorlevel==78 if not errorlevel==79 goto _out
echo 
goto _again

:_err1
echo [40;31;3;5mFile %_prog% not found
goto :_out

:_err2
echo [40;31;3;5mNo such choice available
goto :_again

:_err3
echo [40;31;3m
echo You must have ask.exe at your path (or the current directory)
goto _out

:_out
set _prog=
set _prog1=
set _prog2=
set _prog3=
set _prog4=
set _prog5=
set _found=
echo [0;40;33;1m
echo on
