/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                  This module was written by Bob Hartman                  */
/*                                                                          */
/*                 BinkleyTerm Modem7 Sender State Machine                  */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

int MSInit (XMARGSP);
int MSEnd (XMARGSP);
int MSWaitNak (XMARGSP);
int MSWaitChAck (XMARGSP);
int MSWaitCksm (XMARGSP);

typedef struct
{
	char *state_name;
	int (*state_func) (XMARGSP);
} MSTATES, *MSTATEP;

MSTATES Modem7_Sender[] =
{
	{"MSInit", MSInit},
	{"MSEnd", MSEnd},
	{"MS0", MSWaitNak},
	{"MS1", MSWaitChAck},
	{"MS2", MSWaitCksm}
};

int 
MSInit (XMARGSP args)
{
	char *p;
	int i;
	struct FILEINFO dta;

	XON_DISABLE ();
	args->tries = 0;
	(void) dfind (&dta, args->filename, 0);
	(void) dfind (&dta, NULL, 2);
	(void) strcpy (args->m7name, "           ");
	for (i = 0, p = dta.name; i < 8; p++, i++)
		if ((*p != '.') && (*p != '\0'))
			args->m7name[i] = (char) toupper (*p);
		else
			break;

	if (*p == '.')
		++p;
	for (i = 8; i < 11; p++, i++)
		if ((*p != '.') && (*p != '\0'))
			args->m7name[i] = (char) toupper (*p);
		else
			break;

	/* Now do the checksum */
	args->check = SUB;
	for (i = 0; i < 11; i++)
		args->check += (unsigned char) args->m7name[i];

	return ((int) args->control);
}

int 
MSEnd (XMARGSP args)
{
	args->result = (int) args->control;
	return (args->result);
}

int 
MSWaitNak (XMARGSP args)
{
	if (args->tries >= 10)
		return (FNAME_ERR);

	if (!CARRIER)
		return (CARRIER_ERR);

	if (TIMED_READ (10) != NAK)
	{
		++args->tries;
		return (MS0);
	}

	SENDBYTE (ACK);
	SENDBYTE ((unsigned char) *(args->m7name));
	args->fptr = args->m7name + 1;
	return (MS1);
}

int 
MSWaitChAck (XMARGSP args)
{
	if (!CARRIER)
		return (CARRIER_ERR);

	if (TIMED_READ (10) != ACK)
	{
		++args->tries;
		SENDBYTE ('u');
		return (MS0);
	}

	/* If filename done */
	if (*(args->fptr) == '\0')
	{
		SENDBYTE (SUB);
		return (MS2);
	}
	else
	{
		/* Send next char of name */
		SENDBYTE ((unsigned char) *args->fptr++);
		return (MS1);
	}
}

int 
MSWaitCksm (XMARGSP args)
{
	int in_char;

	if (!CARRIER)
		return (CARRIER_ERR);

	if (((in_char = TIMED_READ (10)) < 0) || ((unsigned char) in_char != args->check))
	{
		SENDBYTE ('u');
		++args->tries;
		return (MS0);
	}
	else
	{
		SENDBYTE (ACK);
		return (SUCCESS);
	}
}

int 
Modem7_Send_File (char *filename)
{
	XMARGS batch;
	int res;

	batch.result = 0;
	batch.filename = filename;
	res = state_machine ((STATEP) Modem7_Sender, &batch, 2);
	return (res);
}
