/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*          This module was originally written by Vince Perriello           */
/*                                                                          */
/*                BinkleyTerm Terminal/Script Upload Module                 */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifdef HAVE_HYDRA
#include "hydra.h"
#endif

/*
 * Handle uploads from terminal mode.
 * Note: filepath parameter below will be trashed if it's a wildcard!
 */

int 
Upload (char *filepath, int prot, char *extern_ptr)
{
	unsigned save1, save2, save3;
	char *p;
	struct FILEINFO fileinfo = {0};

	int err = 1;				/* Xmodem, Ymodem, Telink flag */

	if (dfind (&fileinfo, filepath, 0))
		return (0);

	save1 = comm_bits;
	save2 = parity;
	save3 = stop_bits;
	comm_bits = BITS_8;
	parity = NO_PARITY;
	stop_bits = STOP_1;
	program_baud ();
	XON_DISABLE ();

	/* If external protocol requested, call it */

	if (extern_ptr != NULL)
		do_extern ("Send", prot, filepath);
	else
		switch (prot)
		{
		case 'X':
		case 'Y':
			err = Xmodem_Send_File (filepath, NULL);
			break;

		default:

	/*
     * Find the delimiter on the pathspec for use by the various
     * batch protocols.
     */

			p = strrchr (filepath, '\\');
			if (p == NULL)
				p = strrchr (filepath, '/');
			if (p == NULL)
				p = strchr (filepath, ':');
			if (p == NULL)
				p = filepath;
			else
				p++;

#ifdef HAVE_HYDRA
			if (prot == 'H')
				hydra_init (hydra_options);
#endif	/* HAVE_HYDRA */

	/*  At this point *p points to the location in the input
     *  string where the prepended path information ends. All
     *  we need to do, then, is to keep plugging in the stuff
     *  we get from _dos_find(first|next) and transfer files.
     *  We already have the first matching filename from the
     *  _dos_findfirst we did above, so we use a "do" loop.
     */

			do
			{
				/* Append the current filename */
				(void) strcpy (p, fileinfo.name);

				/* Send the file with the proper protocol */

#ifdef HAVE_HYDRA
				if (prot == 'H')
					err = (hydra (filepath, NULL) == XFER_ABORT) ? FALSE : TRUE;
				else
#endif	/* HAVE_HYDRA */

				if (prot == 'Z')
					err = Send_Zmodem (filepath, NULL, 0, 0);
				else
				{
					err = !Batch_Send (filepath);
				}
			}
			while ((err) && (!dfind (&fileinfo, NULL, 1)));

			/* Finish the proper protocol if need be */

			if (err)
			{

#ifdef HAVE_HYDRA
				if (prot == 'H')
					(void) hydra (NULL, NULL);
				else
#endif	/* HAVE_HYDRA */

				if (prot == 'Z')
					(void) Send_Zmodem (NULL, NULL, END_BATCH, 0);
				else
					(void) Batch_Send (NULL);
			}
			break;
		}

#ifdef HAVE_HYDRA
	if (prot == 'H')
		hydra_deinit();
#endif

	(void) dfind (&fileinfo, NULL, 2);

	comm_bits = save1;
	parity = save2;
	stop_bits = save3;
	program_baud ();
	XON_ENABLE ();
	gong ();

	return (err);
}
