;=============================================================================
	Title	New MASM Functions for DLX
;=============================================================================

; DLX Bulletin Board System V7.0
;
; FREEWARE NOTICE
;
; DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
; Anyone who wishes to may run the program, copy it, or modify it for
; any purpose, including commercial gain.
;

.model	medium,pascal

.code
;-----------------------------------------------------------------------------
; function uc(chara : char) : char;
;
; Force a character to upper case
;-----------------------------------------------------------------------------
uc	proc	chara:byte
	mov	al,chara		; the character
	cmp	al,'a'			; range check
	jb	@F
	cmp	al,'z'
	ja	@F
	sub	al,'a'-'A'		; convert lower case to upper
@@:	ret				; done
uc	endp

;-----------------------------------------------------------------------------
; function lc(chara : char) : char;
;
; Force a character to lower case
;-----------------------------------------------------------------------------
lc	proc	chara:byte
	mov	al,chara		; the character
	cmp	al,'A'			; range check
	jb	@F
	cmp	al,'Z'
	ja	@F
	add	al,'a'-'A'		; convert lower case to upper
@@:	ret				; done
lc	endp

;-----------------------------------------------------------------------------
; procedure ucs(consts s1 : lstring; consts s2 : lstring);
;
; Copy upper case version of s1 to s2
;-----------------------------------------------------------------------------
ucs	proc	uses ds, maxlen1:byte, s1:dword, maxlen2:byte, s2:dword
	cld				; forward direction
	lds	si,s1			; get ptr to s1
	les	di,s2			; get ptr to s2
	lodsb				; s1.len
	mov	cl,al			; to CL
	cmp	cl,maxlen2		; greater than UPPER(s2)?
	jbe	@F			; jump if not
	mov	cl,maxlen2		; limit if so
@@:	stosb				; set s2.len
	xor	ch,ch			; #characters to copy
	jcxz	udone			; done if none to copy
ucloop:	lodsb				; get next character from s1
	cmp	al,'a'			; range check
	jb	@F
	cmp	al,'z'
	ja	@F
	sub	al,'a'-'A'		; convert lower case to upper
@@:	stosb				; store it in s2
	loop	ucloop			; loop back for more
udone:	ret				; exit
ucs	endp

;-----------------------------------------------------------------------------
; procedure lcs(consts s1 : lstring; consts s2 : lstring);
;
; Copy lower case version of s1 to s2
;-----------------------------------------------------------------------------
lcs	proc	uses ds, maxlen1:byte, s1:dword, maxlen2:byte, s2:dword
	cld				; forward direction
	lds	si,s1			; get ptr to s1
	les	di,s2			; get ptr to s2
	lodsb				; s1.len
	mov	cl,al			; to CL
	cmp	cl,maxlen2		; greater than UPPER(s2)?
	jbe	@F			; jump if not
	mov	cl,maxlen2		; limit if so
@@:	stosb				; set s2.len
	xor	ch,ch			; #characters to copy
	jcxz	ldone			; done if none to copy
lcloop:	lodsb				; get next character from s1
	cmp	al,'A'			; range check
	jb	@F
	cmp	al,'Z'
	ja	@F
	add	al,'a'-'A'		; convert upper case to lower
@@:	stosb				; store it in s2
	loop	lcloop			; loop back for more
ldone:	ret				; exit
lcs	endp

;-----------------------------------------------------------------------------
; procedure lseek(handle : integer; newpos : integer4);
;
; Move file pointer (zero origin)
;-----------------------------------------------------------------------------
lseek	proc	handle:word, newposhi:word, newposlo:word
	mov	bx,handle		; file handle
	mov	cx,newposhi		; hiword(fileptr)
	mov	dx,newposlo		; loword(fileptr)
	mov	al,0			; relative to beginning of the file
	mov	ah,42h			; lseek
	int	21h			; dos 2 function
	ret				; done
lseek	endp
	end
