/*

 RNDB.C: Make a DLX database out of the REALNAME file

 DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.

*/	   

#include <stdio.h>
#include <string.h>

FILE *fp;

char szLines[81];
char szFrom[81],szTo[81],szDate[81],szSubject[81];
char szNada[81];
char szName[81],szAddress[81],szCity[81],szPhone[81];

char szBig[400];

MyGets(char *sz)
{
    fgets(sz,81,fp);
    sz[strlen(sz)-1]='\0';
}

main()
{

    int n,nFile,max,nLen;

    if(!(fp = fopen("realname","r")))
	return 1;

    while (!feof(fp))
    {
	MyGets(szLines);
	if (atoi(szLines)!=9) continue;
	
	MyGets(szFrom);
	MyGets(szTo);
	MyGets(szDate);
	MyGets(szSubject);
        MyGets(szNada);
	MyGets(szName);
	MyGets(szAddress);
	MyGets(szCity);
	MyGets(szPhone);

    /* file number */
	nFile = atoi(strrchr(szFrom,' ')+1);
	if (!nFile) break;

	for (max=79;;max--)
	{
	    sprintf(szBig,"#%d %s/%s/%s/%s",
		    nFile,szName,szAddress,szCity,szPhone);
	    nLen = strlen(szBig);
	    if (nLen<80) break;
	    if (strlen(szName)>max)    szName[max]='\0';
	    if (strlen(szAddress)>max) szAddress[max]='\0';
	    if (strlen(szCity)>max)    szCity[max]='\0';
	    if (strlen(szPhone)>max)   szPhone[max]='\0';
	}
	puts(szBig);
    }

    fclose(fp);
    return 0;
}
