{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'database.int'}
{$include: 'load.int'}
{$include: 'sutils.int'}

IMPLEMENTATION OF sutils;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

USES types,globals,utils,database,load;

{***INTERFACE TO THE PASASM ASSEMBLER UTILITIES PACKAGE***}
{$include: 'pasasm.int'}

{Send a private mail message to user number q[wx].correspondent.
 q[wx].send_line_count must be set to the number of lines in the message
 body (don't count the 4 lines of the header).
 Returns true if it succeeds and false if it fails.
 The message is the linked list headed by q[wx].msg_first.
 sendmsg frees the list if it succeeds.}
function sendmsg {boolean};
var
  i : integer;
  p : para;
  h : mailhead;
  str : lstring(80);
begin
  sendmsg:=false;

  {determine whether target is online or not}
  i:=on_line(q[wx].correspondent);
  if i>=0 then {target is online}
    [if ((q[i].state=display_file) and (q[i].return_state=whoelse))
	or else q[i].state in [top..got_pw,
			       news..msgs_4u,
			       mail_gimme1..mail_gimme1j,
			       snip..dummy] then
	{don't interrupt target if she's receiving mail or exiting}
	return

     else {target is online and it's ok to send her mail}
       [q[i].mail_mod:=true;

        {get ptr to last line of message}
        p:=q[wx].msg_first;
	while p<>nill and then p^.link<>nill do p:=p^.link;
	q[wx].msg_last:=p;

	{prepare new mail head and point it to our message}
	newhead(h); h^.head_link:=nil; h^.deleted:=false;
	h^.text_first:=q[wx].msg_first; h^.text_last:=q[wx].msg_last;
	q[wx].msg_first:=nill; q[wx].msg_last:=nill;

        {put it in target's online mailbox}
	if q[i].mbx_first=nil then
	  [h^.index:=1; q[i].mbx_first:=h; q[i].mbx_last:=h]
	else
	  [h^.index:=q[i].mbx_last^.index+1;
	   q[i].mbx_last^.head_link:=h; q[i].mbx_last:=h];

	{bump target's message count}
	if encode(str,(ivalue(q[i].my.mbx_count)+1):1)
	  then kopystr(str,q[i].my.mbx_count);

        if q[i].my.chat_ok[1]<>'P' then notify(i,new_mail_txt)]]

  else {target is not online -- append to her mail file}
    [mbx(mailpath,q[wx].your.userid,str); {construct target's mail filename}

     {open file for append access}
     q[wx].handle:=mult_open(str,0);
     if q[wx].handle<=0 or else
	(not encode(str,(q[wx].send_line_count+4):3)) then
       {someone else is sending mail}
       return;

     {write the message, disposing as we go}
     mail_writeln(q[wx].handle,str);
     while q[wx].msg_first<>nill do begin
       kopylst(q[wx].msg_first^.msg,str); mail_writeln(q[wx].handle,str);
       p:=q[wx].msg_first^.link; dispara(q[wx].msg_first); q[wx].msg_first:=p;
     end {while};

     {close file and clean up}
     q[wx].msg_last:=nill; mail_close(q[wx].handle); q[wx].handle:=0;
     if w^[wx].file_locked<>nill then w^[wx].file_locked^.msg:=null;

     {bump target's message count}
     if encode(str,(ivalue(q[wx].your.mbx_count)+1):1)
       then kopystr(str,q[wx].your.mbx_count);
     dbp_member(q[wx].correspondent,q[wx].your)];

  sendmsg:=true;
end {sendmsg};

{concatenate two paras, modifying the tail of the first}
procedure nconc{var p1 : para; p2 : para};
var
  p : para;
begin
  if p1=nill then
    p1:=p2
  else
    [p:=p1;
     while p^.link<>nill do
       p:=p^.link;
     p^.link:=p2];
end {nconc};

procedure ParaToMsg{t : integer; consts s : string; var b : para};
var
  p : para;
begin
  eval(disk2u(t)); q[wx].correspondent:=t;
  prepare_header;
  p:=newpara(ss[22]); concat(p^.msg,': '); {Subject: } konkat(p^.msg,s);
  q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
  p:=newpara(null); q[wx].msg_last^.link:=p;
  p^.link:=b; b:=nill;
end {ParaToMsg};

procedure AppendPara2File{p : para; vars f : lstring};
begin
  if f=null then return;
  q[wx].handle:=mult_open(f,0); {ignore control Zs}
  if q[wx].handle>0 then
    [while p<>nill do
      [mail_writeln(q[wx].handle,p^.msg); p:=p^.link];
     mail_close(q[wx].handle)];
  if w^[wx].file_locked<>nill then w^[wx].file_locked^.msg:=null;
  q[wx].handle:=0;
end {AppendPara2File};

var beevirg : boolean;
value beevirg := true;
procedure spydump;
var
  l : integer;
begin
  if file_olog=null or else q[wx].xstr=nill
    then return;
  if beevirg then begin
    f_log.trap:=true;
    f_log.errs:=0;
    assign(f_log,file_olog);
    rewrite(f_log);
    writeln(f_log,'Open Forum Log - ',mydate);
    if f_log.errs<>0
      then return;
    beevirg:=false;
  end {if};
  f_log.errs:=0;
  if q[wx].userid<10 then
    l:=1
  else if q[wx].userid<100 then
    l:=2
  else if q[wx].userid<1000 then
    l:=3
  else
    l:=4;
  writeln(f_log,mytime[1],mytime[2],mytime[4],mytime[5],' ',
          q[wx].my.name:(9-l),' ',q[wx].userid:1,' ',q[wx].xstr^.msg);
end {spydump};

{/P at a menu}
procedure SlashP{consts s : lstring; var str : lstring};
var
  i : integer;
  fl : boolean;
begin
  if q[wx].level<priv_gchat then
    display(read_access_txt)
  else
    [delete(str,1,2);
     for i:=1 to ord(str.len) do
       if str[i]>'9' or else str[i]<'0' then
	 [str[0]:=chr(i-1); break];
     fl:=false;
     if str.len>0 and then ok2bother(str,i) and then
	((q[wx].level=9) or
	  ((q[i].logged_in) and
	   ((q[i].my.chat_ok[1]=' ') or
	    ((q[i].my.chat_ok[1]<>'P') and p2chatoff) or
	    gc(i)))) then
	[fl:=true;
	 if q[wx].level=9 or else q[wx].userid<>q[i].squelch then
	   [if q[wx].xstr=nill
	      then q[wx].xstr:=newpara(s)
	      else kopylst(s,q[wx].xstr^.msg);
	    notify(i,gcl_txt);
	    spydump]];
     if not fl then display(gcx2_txt)];
end {SlashP};

END.
