
/* Low-level functions addressing BIOS & PC Hardware */

#include "dos.h"
#include "keys.h"
#pragma inline
static union REGS rg;
#ifdef USECLOCK
    extern void pascal print_clock(void);
#endif
extern cdecl printf(char *,...);

/* Position cursor */

void pascal cursor (int x, int y) {

  rg.x.ax=0x0200;
  rg.x.bx=0;
  rg.x.dx=((y<<8)&0xff00)+x;
  int86 (16,&rg,&rg);
}

/* Return cursor position */

void pascal curr_cursor (int *x,int *y) {

  rg.x.ax=0x0300;
  rg.x.bx=0;
  int86(16,&rg,&rg);
  *x=rg.h.dl;
  *y=rg.h.dh;
}

/* Set cursor type */

void pascal set_cursor_type(int t) {

  rg.x.ax=0x0100;
  rg.x.bx=0;
  rg.x.cx=t;
  int86(16,&rg,&rg);
}

char attrib = 7;

/* Clear screen */

void pascal clear_screen() {

  cursor (0,0);
  rg.h.al=' ';
  rg.h.ah=9;
  rg.x.bx=attrib;
  rg.x.cx=2000;
  int86(16,&rg,&rg);
}

/* Return video mode */

int pascal vmode() {

  rg.h.ah=15;
  int86(16,&rg,&rg);
  return rg.h.al;
}

/* Test for scroll lock */

int pascal scroll_lock() {

  rg.x.ax=0x0200;
  int86(0x16,&rg,&rg);
  return rg.h.al & 0x10;
}

void (*helpfunc)();
int helpkey=0;
int helping=0;

/*Get a keyboard character */

int pascal get_char () {

  int c;

  while(1) {
    rg.h.ah=1;
    int86(0x16,&rg,&rg);
    if (rg.x.flags & 0x40) {
#ifdef USECLOCK
      print_clock();
#endif
      continue;
    }
    rg.h.ah=0;
    int86(0x16,&rg,&rg);
    if (rg.h.al == 0) c=rg.h.ah | 128;
    else c=rg.h.al;
    if (c==helpkey && helpfunc) {
       if (!helping) {
         helping=1;
         (*helpfunc)();
         helping=0;
         continue;
       }
     }
     break;
   }
   return c;
}


void pascal vpoke (unsigned vseg, unsigned adr, unsigned chr) {

	if (vseg == 45056)
		poke(vseg,adr,chr);
	else {
		_DI=adr;
		_ES=vseg;
		asm cld;
		_BX=chr;
		_DX=986;

		do
			asm in al,dx;
		while (_AL & 1);

		do
			asm in al,dx;
		while (!(_AL & 1));
		_AL = _BL;
		asm stosb;

		do
			asm in al,dx;
		while (_AL & 1);

		do
			asm in al,dx;
		while(!(_AL & 1));
		_AL = _BH;
		asm stosb;
	}
}

int pascal vpeek(unsigned vseg, unsigned adr) {

	int ch,at;

	if (vseg == 45056)
		return peek(vseg,adr);
	asm push ds;
	_DX=986;
	_DS=vseg;
	_SI=adr;
	asm cld;

	do
		asm in al,dx;
	while(_AL & 1);

	do
		asm in al,dx;
	while(!(_AL & 1));
	asm lodsb;
	_BL = _AL;

	do
		asm in al,dx;
	while(_AL & 1);

	do
		asm in al,dx;
	while(!(_AL & 1));
	asm lodsb;
	_BH=_AL;
	_AX=_BX;
	asm pop ds;
	return _AX;
}

/* End of IBMPC.C File */
