{
  File format for door info file
}

TYPE

  DataFileType =
  RECORD

    {----- User information -----}

    RealName    : STRING[20];  { Real name }
    Phone       : STRING[25];  { Voice phone number }
    UserName    : STRING[20];  { Sign-on name }
    Level       : BYTE;        { Membership level }
    Dayt        : WORD;        { Today's day number (# of days since 01/01/88) }
    Dayt_Last   : WORD;        { Day number of last visit }
    Mint_Last   : WORD;        { Minute-of-the-day of last visit }
    StartDayt   : WORD;        { Day number when this visit began }
    StartMint   : WORD;        { Minute-of-the-day when this visit began }
    StartDay    : WORD;        { Day of week (0-6, 0=Sunday) visit began }
    StartHr     : WORD;        { Hour of day (0-23) visit began }
    StartMn     : WORD;        { Minute of hour (0-59) visit began }
    Width       : WORD;        { Terminal width }
    Depth       : WORD;        { Screen depth }
    DefGear     : BYTE;        { Default gear }
    DefWrap     : BOOLEAN;     { Use word-wrap? }
    Colour      : BOOLEAN;     { Use ANSI colour controls? }
    NumVisits   : WORD;        { Number of visits to this BBS }
    Protocol    : CHAR;        { Upload/Download protocol }

    {----- System information -----}

    ComPort     : INTEGER;     { Port address (see CONFIG program) }
    TimeLeft    : INTEGER;     { Number of minutes left in call }
    XBaudRateX  : INTEGER;     { Won't work above 32767 -- see BaudRateDCE }
    ConsColour  : BOOLEAN;     { Can the console display colour? }
    ConsLines   : WORD;        { Number of lines possible on console screen }
    Floppies    : BOOLEAN;     { Is this a diskette-based system? }
    Noisey      : BOOLEAN;     { Should sound effects be played at console? }
    TalkToCom   : BOOLEAN;     { Is this session via the serial port? }
    LastEvNum   : BYTE;        { Number of the last event }
    FrontEnd    : BOOLEAN;     { Is Sapphire running under a front-end? }
    LocalRun    : BOOLEAN;     { Was Sapphire started with LOCAL? }

    {----- Path information -----} { All paths end in \ }

    DFLocation  : STRING[40];  { Path to SRUN directory }
    LFLocation  : STRING[40];  { Path to text library directory }
    MFLocation  : STRING[40];  { Path to messages directory }
    FFLocation  : STRING[40];  { Path to software library directory }
    File_SysLog : STRING[12];  { Name of system log file }
    File_Users  : STRING[12];  { Name of users file }

    {----- Integration data -----}

    { Not updated after exit from door }

    CmdParm     : STRING[80];  { Remnant from command line }

    { Updated after exit from door }

    NamesString : STRING[80];  { String entered into NAMES command }
    TextString  : STRING[80];  { String entered into TEXT  command }
    Warn2       : BOOLEAN;     { Has user received 2-minutes-left warning? }
    Warn5       : BOOLEAN;     { Has user received 5-minutes-left warning? }

    {----- Expansion -----}

    BaudRateDCE : LONGINT;     { Baud rate: modem-to-remote-user }
    BaudRateDTE : LONGINT;     { Baud rate: modem-to-computer }
    LockedBaud  : BOOLEAN;     { Does the DTE operate at a fixed speed? }

    {

     Any file data following this point are as yet undefined.  However, your
     program should allow the existance of additional data; it is not guaran-
     teed that there will be an EOF here.  Extra fields may be added at a
     later date, as assigned by Pinnacle Software.

    }

  END;
