#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          GWTOP - Topology         */
/*        MS-WINDOWS front end       */
/*                                   */
/*         Kinetics dialog box       */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwtop.h"						/* macros, function prototypes, etc.	*/
#include "gep1.h"						/* gepasi's variables					*/
#include "topgvar.h"					/* global variables						*/


void ReactSel( HWND hKL, int item );

#pragma alloc_text( CODE3, ReactSel, EdKinet )

void ReactSel( HWND hKL, int item )
{
 int noel, i, j;
 unsigned char subs, prods;

 /* empty the kinetics list box										*/
 SendMessage( hKL, LB_RESETCONTENT, 0, 0 );

 /* count the substrates and products								*/
 for( i=0, prods=subs=0; i<MAX_MOL; i++ )
 {
  if( (*rstr)[item][i] > 0 ) prods++;
  else if( (*rstr)[item][i] < 0 ) subs++;
 }

 SendMessage( hKL, WM_SETREDRAW, FALSE, 0 );

 /* first insert the <not defined> type								*/
 SendMessage( hKL, LB_INSERTSTRING, 0, (DWORD) ktype[NOT].descr );
 ktype[NOT].idx = 0;

 /* insert all reaction types that have that number of effectors or less	*/
 for( i=1, j=1; i<nrateq; i++)
 {
  if( (ktype[i].nsub <= subs) &&
  	  (ktype[i].npro <= prods) &&
  	  (ktype[i].revers == revers[item])
  	)
  {
   if( ! lstrcmp( (LPSTR) "mass action", (LPSTR) ktype[i].descr ) )
   {
    if( (ktype[i].nsub == subs) && (ktype[i].npro == prods) )
    {
/*     wsprintf( (LPSTR) szString, "%d", i );
     MessageBox( hKL, szString, (LPSTR) "mass action", MB_ICONINFORMATION );*/
     SendMessage( hKL, LB_INSERTSTRING, j, (DWORD) ktype[i].descr );
     ktype[i].idx = j;
     j++;
  	}
    else ktype[i].idx = -1;
   }
   else
   {
    SendMessage( hKL, LB_INSERTSTRING, j, (DWORD) ktype[i].descr );
    ktype[i].idx = j;
    j++;
   }
  }
  else ktype[i].idx = -1;
 }
 SendMessage( hKL, WM_SETREDRAW, TRUE, 0 );

 /* highlight the selected kinetic type							*/
 if( kinet[item] != -1 )
  SendMessage( hKL, LB_SETCURSEL, (WORD) ktype[kinet[item]].idx, 0 );
}

BOOL FAR PASCAL EdKinet( HWND hDlg, WORD message, WORD wParam, LONG lParam )
{
 static	HWND	hReactLst, hKinetLst, hName;
 int i, j, r;

 switch( message )
 {
  case WM_INITDIALOG:                                   /*message: initialize dialog box        */
   lbWidth = 0;											/* set the width of the list box to 0	*/

   /* and show the image on the mirror.			*/
   _fmemcpy( (void __far *) kinet,
   	         (void __far *) kinetu,
             (size_t) MAX_STEP * sizeof( int ) );
   _fmemcpy( (void __far *) lp,
   	         (void __far *) loop,
             (size_t) MAX_STEP * MAX_MET * sizeof( unsigned char ) );
   _fmemcpy( (void __far *) nmd,
 	         (void __far *) nmod,
             (size_t) MAX_STEP * sizeof( unsigned char ) );
   kass = kinass;
   lass = loopass;
   nlps = nloops;

   /* get handles to controls					*/
   hKinetLst = GetDlgItem( hDlg, IDC_KINETLST );
   hReactLst = GetDlgItem( hDlg, IDC_REACTLST );
   hName     = GetDlgItem( hDlg, IDSTAT_3 );

   /* initialize hReactLst: add all reactions */
   for( i=0; i<nsteps; i++ )
    AddReactLst( hReactLst, i, 1, 0, &totmet, metname, stoiu, intmet, revers, rstr );

   /* select the first reaction of hReactLst  */
   SendMessage( hReactLst, LB_SETCURSEL, 0, 0 );
   SendMessage( hName, WM_SETTEXT, 0, (DWORD) (LPSTR) stepname[0] );
   ReactSel( hKinetLst, 0 );
   return( TRUE );

  case WM_COMMAND:
   switch( wParam )
   {
    case IDC_REACTLST:
     if( HIWORD( lParam ) == LBN_SELCHANGE )
     {
      i = (int) SendMessage( hReactLst, LB_GETCURSEL, 0, 0 );
      SendMessage( hName, WM_SETTEXT, 0, (DWORD) (LPSTR) stepname[i] );
      ReactSel( hKinetLst, i );
      return( TRUE );
     }
     else return FALSE;

    case IDC_KINETLST:
     if( HIWORD( lParam ) == LBN_SELCHANGE )
     {
      r = (int) SendMessage( hReactLst, LB_GETCURSEL, 0, 0 );
      i = (int) SendMessage( hKinetLst, LB_GETCURSEL, 0, 0 );
      if( i != LB_ERR )
      {
       for( j=0; j<nrateq; j++ )
       {
        if( ktype[j].idx == i )
        {
         if( kinet[r] == NOT ) kass++;					/*increase or decrease kass		*/
         if( j == NOT ) kass--;
         if( ktype[kinet[r]].nmodf > 0 )
         {
          nlps--;										/*previous type had modfs.		*/
          if( ktype[kinet[r]].nmodf == nmd[r] ) lass--;	/*and have been assigned		*/
         }
         if( ktype[j].nmodf>0 ) nlps++;					/*this type has modfs.			*/
         kinet[r] = j;									/* finally assign kinetic type	*/
         break;
        }
       }
      }
	  return TRUE;
	 }
	 else return FALSE;

    case IDC_HELP:                        /* Help for this Dialog Box			 */
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Kinetics editor" );
     return TRUE;

    case IDOK:
     /* copy the altered image to the original		*/
     _fmemcpy( (void __far *) kinetu,
   	           (void __far *) kinet,
               (size_t) MAX_STEP * sizeof( int ) );
     _fmemcpy( (void __far *) loop,
   	           (void __far *) lp,
               (size_t) MAX_STEP * MAX_MET * sizeof( unsigned char ) );
     _fmemcpy( (void __far *) nmod,
   	           (void __far *) nmd,
               (size_t) MAX_STEP * sizeof( unsigned char ) );
     kinass = kass;
     loopass = lass;
     nloops = nlps;

     notsaved = 1;
     /* close the dialog box and return				*/
     EndDialog( hDlg, IDOK );
     return TRUE;

    case IDCANCEL:
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDCANCEL );
     return TRUE;
   }

  default: return FALSE;
 }
}