#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*          Scan Boundaries          */
/*            dialog box             */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/

#pragma alloc_text( CODE8, EdScanB)

BOOL FAR PASCAL EdScanB(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static csel, nsel;
 static HWND hSelect, hLow, hHigh, hDens, hLog;
 int  i, j, len;
 char buff[128];
 unsigned long d;

 switch(Message)
 {
  case WM_INITDIALOG:
   /* allocate memory for the mirror				*/
   hScp = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, sizespar );
   if( hScp == NULL )
   {
    LoadString(hInst, IDS_ERR_NOEXEC, szString, sizeof(szString));
    MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
    EndDialog(hDlg, FALSE);
    return TRUE;
   }

   /* lock the memory block							*/
   scp  = (struct sp huge *) GlobalLock( hScp );

   /* copy params to its mirror									*/
   _fmemcpy( (void __far *) scp,
             (void __far *) spar,
		     (size_t) sizespar );

   /* get handles to controls						*/
   hSelect = GetDlgItem( hDlg, IDC_SELECT );
   hLow = GetDlgItem( hDlg, IDE_M0 );
   hHigh = GetDlgItem( hDlg, IDE_M1 );
   hDens = GetDlgItem( hDlg, IDE_M2 );
   hLog = GetDlgItem( hDlg, IDC_LOG );

   /* initialize hSelect: add all selected elements	*/
   for( i=0, lbWidth=0; i<totscan; i++ )
    for( j=0; j<nscanpar; j++ )
     if( (scp[j].idx-1) ==  i )
      AddPLst( hSelect, j, TRUE );

   /* select the first element						*/
   nsel = 0;
   SendMessage( hSelect, LB_SETCURSEL, (WORD) nsel, 0 );
   for( i=0; i<nscanpar; i++ )
    if( scp[i].idx-1 == nsel ) csel = i;

   /* check the log button if appropriate 			*/
   i= scp[csel].log;
   SendMessage( hLog, BM_SETCHECK, (WORD) i, 0 );

   /* write the numeric values in the edit boxes	*/
   gcvt( scp[csel].low, 16, buff );
   SendMessage( hLow, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   gcvt( scp[csel].high, 16, buff );
   SendMessage( hHigh, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   if( options.scan==1 ) ultoa( (int) scp[csel].dens, buff, 10 );
   else ultoa( options.scandens, buff, 10 );
   SendMessage( hDens, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );

   InvalidateRect( hDlg, NULL, FALSE );
   return TRUE;

  case WM_COMMAND:
   switch(wParam)
   {
    case IDC_SELECT:
     if( HIWORD( lParam ) == LBN_SELCHANGE )
     {
      /*get the parameters for the old selection	*/
      /* check the log button	 		 			*/
      scp[csel].log = (int) SendMessage( hLog, BM_GETCHECK, 0, 0 );
      /* read the numeric values from the edit boxes*/
      len = (int) SendMessage( hLow, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
      if( len>0 ) scp[csel].low = strtod( buff, NULL );
      if( (scp[csel].low==HUGE_VAL) || (scp[csel].low==-HUGE_VAL)  || (len==0) )
      {
       LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
       MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
       SendMessage( hSelect, LB_SETCURSEL, (WORD) nsel, 0 );
       SetFocus( hLow );
       return TRUE;
      }
      len = (int) SendMessage( hHigh, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
      if( len>0 ) scp[csel].high = strtod( buff, NULL );
      if( (scp[csel].high==HUGE_VAL) || (scp[csel].high==-HUGE_VAL)  || (len==0) )
      {
       LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
       MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
       SendMessage( hSelect, LB_SETCURSEL, (WORD) nsel, 0 );
       SetFocus( hHigh );
       return TRUE;
      }
      len = (int) SendMessage( hDens, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
      if( len>0 ) d = strtoul( buff, NULL, 10 );
      if( (len==0) || (d==0) )
      {
       LoadString(hInst, IDS_ERR_ZEROBAD, szString, sizeof(szString));
       MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
       SendMessage( hSelect, LB_SETCURSEL, (WORD) nsel, 0 );
       SetFocus( hDens );
       return TRUE;
      }
      if( options.scan==1 ) scp[csel].dens = d;
      else options.scandens = d;

      /* get the index of the new element selected					*/
      nsel = (int) SendMessage( hSelect, LB_GETCURSEL, 0, 0 );
      if( nsel != LB_ERR )
      {
       for( i=0; i<nscanpar; i++ )
        if( scp[i].idx == nsel+1 ) csel = i;

       /* check the log button if appropriate 			*/
       i= scp[csel].log;
       SendMessage( hLog, BM_SETCHECK, (WORD) i, 0 );

       /* write the numeric values in the edit boxes	*/
       gcvt( scp[csel].low, 16, buff );
       SendMessage( hLow, WM_SETTEXT, 0,(DWORD)(LPSTR) buff );
       gcvt( scp[csel].high, 16, buff );
       SendMessage( hHigh, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
       if( options.scan==1 ) ultoa( scp[csel].dens, buff, 10 );
       else ultoa( options.scandens, buff, 10 );
       SendMessage( hDens, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );

       InvalidateRect( hDlg, NULL, FALSE );
       return TRUE;
      }
     }
     else return FALSE;

    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Scan boundaries" );
     return TRUE;

    case IDOK:
     /* check the log button	 		 			*/
     scp[csel].log = (int) SendMessage( hLog, BM_GETCHECK, 0, 0 );
     /* read the numeric values from the edit boxes*/
     len = (int) SendMessage( hLow, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
     if( len>0 ) scp[csel].low = strtod( buff, NULL );
     if( (scp[csel].low==HUGE_VAL) || (scp[csel].low==-HUGE_VAL)  || (len==0) )
     {
      LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SendMessage( hSelect, LB_SETCURSEL, (WORD) nsel, 0 );
      SetFocus( hLow );
      return TRUE;
     }
     len = (int) SendMessage( hHigh, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
     if( len>0 ) scp[csel].high = strtod( buff, NULL );
     if( (scp[csel].high==HUGE_VAL) || (scp[csel].high==-HUGE_VAL)  || (len==0) )
     {
      LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SendMessage( hSelect, LB_SETCURSEL, (WORD) nsel, 0 );
      SetFocus( hHigh );
      return TRUE;
     }
     len = (int) SendMessage( hDens, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
     if( len>0 ) d = strtoul( buff, NULL, 10 );
     if( (len==0) || (d==0) )
     {
      LoadString(hInst, IDS_ERR_ZEROBAD, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SendMessage( hSelect, LB_SETCURSEL, (WORD) nsel, 0 );
      SetFocus( hDens );
      return TRUE;
     }
     if( options.scan==1 ) scp[csel].dens = d;
     else options.scandens = d;

     /* copy params back from its mirror								*/
     _fmemcpy( (void __far *) spar,
               (void __far *) scp,
		       (size_t) sizespar );
     /* unlock and free the mirror memory block             */
     GlobalUnlock( hScp );
     GlobalFree( hScp );
     /* signal that changes have been made					*/
	 notsaved = 1;
     EndDialog(hDlg, TRUE);
     return TRUE;

    case IDCANCEL:
     /* unlock and free the mirror memory block             */
     GlobalUnlock( hOel );
     GlobalFree( hOel );
     EndDialog(hDlg, FALSE);
     return TRUE;
   }    /* End of WM_COMMAND                                 */
   return FALSE;

  default:
   return FALSE;
 }
}

