#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          global variables         */
/*                                   */
/*        Zortech C/C++ 3.0 r4       */
/*          MICROSOFT C 6.00         */
/*          Visual C/C++ 1.0         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/

#ifndef MSDOS
#define COMMON
#endif

#ifdef _WINDOWS
#define COMMON
#endif

#include <setjmp.h>
#include "globals.h"                                /* global symbols        */

 double xss[MAX_MET];                     /* concentrations at the s.s.     */
 double x[MAX_MET];                       /* concentrations at time t       */
 double x0[MAX_MET];                      /* concentrations at time 0       */
 double moiety[MAX_MET];                  /* total conserved moiety conc.   */
 double rate[MAX_MET];                    /* rates at time t                */
 double flux[MAX_STEP];                   /* fluxes at time t               */
 double cum[MAX_MET];					  /* cumulative lyapunov exponents  */
 double tt[MAX_MET];                      /* lifetimes                      */
 double ttt;                              /* pathway lifetime               */
 int totmet;                              /* number of total metabolites    */
 int nmetab;                              /* number of internal metabolites */
 int nextmet;                             /* number of external metabolites */
 int indmet;                              /* number of int. indp. metabs.   */
 int depmet;                              /* number of int. dep. metabs.    */
 int nsteps;                              /* number of steps                */
 double endtime;                          /* time value for last iteration  */
 double actime;                           /* current time                   */
 double step;                             /* initial step for integration   */
 char metname[MAX_MET][NAME_L];           /* metabolite names               */
 char stepname[MAX_STEP][NAME_L];         /* metabolite names               */
 int intmet[MAX_MET];                     /* 1 if internal metabolite       */
 int ur[MAX_MET];                         /* permut. on metabolites  u -> g */
 int uc[MAX_MET];                         /* permutations on steps   u -> g */
 extern float ml[MAX_MET][MAX_MET];       /* multipliers of gauss reduction */
 extern float lm[MAX_MET][MAX_MET];       /* inverse of ml                  */
 extern float ld[MAX_MET][MAX_MET];       /* metabolite linear dependencies */
 extern float rstoi[MAX_MET][MAX_STEP];   /* reduced stoicheiometric matrix */
 int stoiu[MAX_MET][MAX_STEP];            /* user stoicheiometric matrix    */
 int stoi[MAX_MET][MAX_STEP];             /* stoicheiometric matrix         */
 int kinetu[MAX_STEP];                    /* type of kinetics (user numb.)  */
 int kinetype[MAX_STEP];                  /* type of kinetics of each step  */
 unsigned char (*loop)[MAX_STEP][MAX_MET];/* def. of modification loops		*/
 int (*rstr)[MAX_STEP][MAX_MOL];		  /* reaction structure				*/
 double jacob[MAX_MET][MAX_MET];          /* jacobian of rates at time t    */
 extern double Dxv[MAX_STEP][MAX_MET];    /*  ---+                          */
 extern double Duv[MAX_STEP][MAX_MET];    /*     |    defined in            */
 extern double DuJ[MAX_STEP][MAX_MET];    /*     |    metcvars.c            */
 extern double Gamma[MAX_MET][MAX_STEP];  /*     |    compiled              */
 extern double C[MAX_STEP][MAX_STEP];     /*     |    separatly             */
 extern double ttcc[MAX_MET];             /*  ---+                          */
 double (*rateq[MAX_STEP])();             /* pointers to rate equations     */
 double (*partder[MAX_STEP][MAX_MET])();  /* pointers to partial derivatives*/

 double intst, nfeval, njeval;            /* double vers. of nst, nfe & nje	*/
/*******************************************************/
/*      Organization of metabolite based matrices      */
/*                                                     */
/*        0        ---+  +-                            */
/*        .           |  |                             */
/*        .           |  | indmet                      */
/*        .           |  |                             */
/*        indmet     -+  +-                            */
/*        .           |  |                             */
/*        .           |  | depmet                      */
/*        .           |  |                             */
/*        nmetab    --+  +-                            */
/*        .           |  |                             */
/*        .           |  | nextmet                     */
/*        .           |  |                             */
/*        totmetab ---+  +-                            */
/*                                                     */
/*******************************************************/

/**************************/
/* FLOW CONTROL VARIABLES */
/**************************/
 float ver_no;							  /* .sim file version              */
 unsigned long iter;					  /* number of current iteration	*/
 int fperr;                               /* fp error number                */
 int cx, cy;                              /* ptrs for cursor position       */
 int nrunfiles;                           /* number of files to run         */
 int delete;							  /* 1 to delete list file at end	*/
 int newtlim=50;                          /* limit of iterations on Newton  */
 char inputf[PWIDTH];                     /* list file name                 */
 char filename[MAX_FIL][PWIDTH];          /* run filenames                  */
 char repfile[PWIDTH];					  /* filename for report file		*/
 char dyname[PWIDTH];                     /* filename for dyn file		    */
 char TopFile[PWIDTH];                    /* topology filename              */
 char listfile[PWIDTH];					  /* file with list of simulations	*/
 jmp_buf	mark;						  /* mark for longjmp (fp exceptions*/
 int	jmpret;							  /* return value of setjmp			*/
 int	fperr;						      /* floting point error number		*/

/********************/
/* STRING VARIABLES */
/********************/

 char fpstr[128] = "\0";
 char topname[256] = "\0";				  /* pathway title					*/
 char *errormsg[]=
 {
  " - ",
  " - ",
  "\nGEPASI aborted.\n",
  " - ",
  "  * Out of memory.",
  " - ",
  "  * Undefined error. Please report to developer!",
  "Syntax error.",
  "  * Error in file I/O: unable to save.",
  "  * Error in file I/O: unable to load.",
  "Unable to delete item.",
  "  * Error in topology: step number out of bounds.",
  "  * Error in topology: metabolite number out of bounds.",
  "  * Error in topology: bad title.",
  " - ",
  "  * Error in topology: step number out of bounds.",
  "  * Error in topology: possibly bad kinetic type.",
  "  * Error in topology: metabolite number out of bounds.",
  "  * Error in topology: bad stoicheiometry matrix.",
  "  * Error in topology: bad interaction loop matrix.",
  "  * Error in topology: bad metabolite status.",
  "  * Error in parameters: invalid concentration.",
  "  * Error in parameters: kinetic constant missing.",
  " - ",
  "  * Topology file incomplete.",
  "  * Error in parameters: invalid units.",
  "  * Error in parameters: invalid option.",
  " - ",
  " - ",
  " - ",
  " - ",
  "No you don't!\nThis function is not yet working..."
  };
#ifndef COMMON
 char *gepasi = "GEPASI 2.0 pc (C)1989/92/93 by Pedro Mendes";
#endif
#ifdef unix
 char *gepasi = "GEPASI 2.0 unix (C)1989/92/93 by Pedro Mendes";
#endif
#ifdef _WINDOWS
 char *gepasi = "GEPASI 2.0 win3 (C)1989/92/93 by Pedro Mendes";
#endif
 char *version_no = "release 2.08";
