/*
 * Activate.h
 *
 * Header file for Activate.c
 *
 */


#define NUMBER_OF_SYSTEM_TYPES	32
#define BAD_COMMAND_LINE	 1
#define BAD_PARTITION_NUMBER	 2

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


typedef unsigned char byte;

typedef struct
{
  byte boot_flag;
  byte start_sector_head;
  byte start_sector;
  byte start_cylinder;
  byte ID;
  byte end_sector_head;
  byte end_sector;
  byte end_cylinder;
  long sectors_in_preceding_partn;
  long sectors_in_partn;
} partition_table_entry;

typedef struct
{
  partition_table_entry entry[4];
  byte signature[2];                    /* Should be 55 AA for valid disk */
} partition_table;

typedef struct
{
  byte ID;
  char *Desc;
} systypes;

typedef struct
{
  byte Side;
  int  Cylinder;
  byte Sector;
} location;

extern byte buffer[];                                 /* stores 1st sector */
