/********************************************************************
*  F I L E C O P Y
*
*  Copy the input stream to the output stream.  Return 0 if the
*  copy is successful or EOF for any I/O error.
********************************************************************/

#include <stdio.h>

int
filecopy(fin, fout)
FILE *fin;	/* input stream pointer */
FILE *fout;	/* output stream pointer */
{
    int ch;	/* holds ASCII characters and EOF */
    int rcode;	/* return code */

    /*
     *  Copy input to output until end of file is reached
     *  or an I/O error occurs.
     */
    rcode = 0;
    while ((ch = getc(fin)) != EOF)
        if (putc(ch, fout) == EOF) {
            rcode = EOF;	/* output error */
            break;
        }

    if (ferror(fin))
        rcode = EOF;		/* input error */

    return (rcode);
}
