#ifndef __TV2__H
#define __TV2__H

#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TSItem
#define Uses_TListBox
#define Uses_TButton
#define Uses_TView
#define Uses_TDialog
#define Uses_TWidonw
#define Uses_TWidonwInit
#define Uses_TCollection
#include <tv.h>


const int cmEnumChange = 2041;

/*====================================*/
class TInput_float: public  TInputLine
/*====================================*/
      {
         public:
         virtual ushort dataSize();
         virtual void   getData(void *rec);
         virtual void   setData(void *rec);
         TInput_float (const TRect& bounds, int aMaxLen):
               TInputLine(bounds,aMaxLen) {};
//         ~TInput_float ();
      };

// The only reason to create following class is to make protected
// field count of TCollection accessible
/*====================================*/
class TCollection2 : public TCollection
/*====================================*/
{
public:
  TCollection2( ccIndex aLimit, ccIndex aDelta ):
        TCollection( aLimit, aDelta ) {};
  ccIndex size() { return count; };
    virtual void *readItem( ipstream& is) = 0;
    virtual void writeItem( void *obj, opstream& os) = 0;
};


/*====================================*/
class TStrCollection : public TCollection2
/*====================================*/
{
public:
    TStrCollection( short aLimit, short aDelta ):
                  TCollection2(aLimit, aDelta) {};
private:
    virtual void freeItem( void *item )
    { if (item!=NULL) delete item; }

    // virtual const char *streamableName() const
    //    { return name; }
    virtual void *readItem( ipstream& is)
    {  return is.readString(); }
    virtual void writeItem( void *obj, opstream& os)
    {  os.writeString( (const char *)obj ); }
//protected:
//    TStringCollection( StreamableInit ) : TSortedCollection ( streamableInit ) {};
//public:
//    static const char * const near name;
//    static TStreamable *build();
};



/*==============================*/
class TDialogDbl: public TDialog
/*==============================*/
{
   public:
   //TWindowInit::TWindowInit ( TFrame *(*cFrame)( TRect ) ):
   // TWindowInit( cFrame ) {};
   TDialogDbl (const TRect& bounds, const char* aTitle):
              TDialog (bounds, aTitle),
              TWindowInit( &TDialog::initFrame )
               {};
   virtual void handleEvent(TEvent& event);
};

/*===================================*/
class TEnumArrow : public TStaticText
/*===================================*/
{
    TView *Link;
public:
    TEnumArrow( const TRect& bounds, const char *aTitle,
                TView *aLink );
    virtual void handleEvent( TEvent& event );
    virtual TPalette& getPalette() const;
    // virtual void shutDown();
};


/*=================================*/
class TEnumValue : public TInputLine
/*=================================*/
{
public:
    TCollection2  *List;
    ccIndex       focusedItem;
    TEnumValue( const TRect& bounds, int aMaxLen );
    // ~TEnumValue();
    virtual void newFocusedItem( ccIndex newItem );
    virtual void newList ( TCollection2 *aList, ccIndex focusedNo );
    virtual void handleEvent( TEvent& event );
    virtual void MakeSelection();
    virtual ushort dataSize() { return sizeof(ccIndex); };
    virtual void   getData(void *rec);
    virtual void   setData(void *rec);
    // virtual void shutDown();
};

#endif // __TV2__H