/*---------------------------------------------------------*/
/*                                                         */
/*   Turbo Vision 1.0                                      */
/*   Turbo Vision BGI Support Demo Header File             */
/*   Copyright (c) 1991 by Borland International           */
/*                                                         */
/*---------------------------------------------------------*/

#if !defined( __TVBGI_H )
#define __TVBGI_H

#define Uses_TApplication
#define Uses_TMenuBar
#define Uses_TStatusLine
#include <tv.h>
#include "tv2.h"

const
   MAXSIZE = 150,
   MAXPATH = 80;

const
   cmNewWin       = 1000,
   cmGraphOptions = 1002,
   // cmDoGraphics   = 1003,

   cmReportStatus       = 4004,
   cmBar3DDemo          = 4005,
   cmRandomBars         = 4006,
   cmColorDemo          = 4007,
   cmArcDemo            = 4008,
   cmCircleDemo         = 4009,
   cmPieDemo            = 4010,
   cmBarDemo            = 4011,
   cmLineRelDemo        = 4012,
   cmPutPixelDemo       = 4013,
   cmPutImageDemo       = 4014,
   cmLineToDemo         = 4015,
   cmLineStyleDemo      = 4016,
   cmUserLineStyleDemo  = 4017,
   cmFillStyleDemo      = 4018,
   cmFillPatternDemo    = 4019,
   cmPolyDemo           = 4020;

const
   hlChangeDir  = cmChangeDir,        // History list ID
   hlSetBGIPath = 4002;       // History list ID

const int hcGraphBuild = 0xFFFE,
          hcGraphPrint = 0xFFFF;

class TBGIApp : public TApplication
{
public:

    TBGIApp();
    virtual ~TBGIApp();

    virtual void handleEvent( TEvent& Event );
    static TMenuBar *initMenuBar( TRect );
    static TStatusLine *initStatusLine( TRect );
    virtual void outOfMemory();
    void newWin();
    void doGraphics(int far func(void far * UserPointer), void far* UserPointer);
    void SetGraphOptions();
    void changeDir();
    void tile();
    void cascade();

    int appDriver;
    int appMode;
    struct { char bgiPath[MAXPATH];
             char PrintDest[MAXPATH];
             float  PicWidth,PicHeight;
             int    Preview,StdBGI;
             ccIndex PrinterNo,PRTModeNo;
           } Options;
};

class TEnumMode;
class TEnumPrinter: public TEnumValue
{
   public:
   TEnumMode *EnumM;
   TEnumPrinter(const TRect& bounds );
   virtual void newFocusedItem( ccIndex newItem );
};

class TEnumMode: public TEnumValue
{
   const TEnumPrinter *EnumP;
   public:
   TEnumMode ( const TRect& bounds, const TEnumPrinter *EP );
   virtual void MakeSelection();
   Boolean setModes(Boolean errMsg);
};


extern Boolean graphActive;
extern void    *driverPtr;
extern unsigned int driverSize;
extern char  emptyString[];
//extern char *bgiPath;
extern int driver;
extern int mode;

extern Boolean graphAppInit( int, int, char *, Boolean);
extern void graphAppDone();
extern Boolean graphicsStart();
extern void graphicsStop();

#endif  // __TVBGI_H
