/*++


Module Name:

    vfsdebug.h

Abstract:

    This module defines debug services for VFS

Author:

    Ahdrey Shedel

Revision History:

    27/12/2002 - Andrey Shedel - Created

--*/



#if !defined(UFSD_DEBUG) && !defined(NDEBUG)
#define UFSD_DEBUG 1
#endif /*!defined(UFSD_DEBUG) && !defined(NDEBUG)*/



#ifdef UFSD_DEBUG

#define DEBUG_TRACE_ALWAYS         0x00000000
#define DEBUG_TRACE_ERROR          0x00000001
#define DEBUG_TRACE_DEBUG_HOOKS    0x00000002
#define DEBUG_TRACE_BLOCKIO        0x00000040
#define DEBUG_TRACE_UFSDAPI        0x00000080
#define DEBUG_TRACE_MEMMNGR        0x00000100
#define DEBUG_TRACE_RWBLOCK        0x00000200
#define DEBUG_TRACE_STRINGS        0x00000400
#define DEBUG_TRACE_TIME           0x00000800
#define DEBUG_TRACE_CACHE          0x00001000
#define DEBUG_TRACE_VFS            0x00002000


#define ASSERT(cond) {                                         \
	if (!(cond)) {                                             \
		UFSD_DebugPrintf("***** assertion failed: "#cond" at "  \
		                 __FILE__": %u\n", __LINE__);\
	}                                                          \
}

#define VERIFY(cond) ASSERT(cond)
#define DEBUG_ONLY(e) e
#define C_ASSERT(e) \
	typedef char _C_ASSERT_[(e)?1:-1];


extern long UFSD_DebugTraceLevel;

EXTERN_C int UFSD_DebugTracePre(long INDENT, long LEVEL);
EXTERN_C void UFSD_DebugTracePost(long INDENT);
EXTERN_C void UFSD_DebugPrintf(const char *pszfmt, ...)
    __attribute__ ((format (printf, 1, 2)));;

#define DebugTrace(INDENT,LEVEL,X) {                              \
	if (UFSD_DebugTracePre(INDENT,LEVEL)) {                       \
		UFSD_DebugPrintf X;                                       \
		UFSD_DebugTracePost(INDENT);                              \
	}                                                             \
}


#define DebugUnwind(s) NOTHING;



#else

#define ASSERT(cond) NOTHING;
#define VERIFY(cond) {(void)(cond);}
#define DEBUG_ONLY(e)
#define UFSD_DumpAep(aep, Mask) NOTHING;
#define DebugTrace(i, l, x) NOTHING;
#define DebugUnwind(s) NOTHING;
#define C_ASSERT(e)

#endif /*UFSD_DEBUG*/


#ifndef UNREFERENCED_PARAMETER
#define UNREFERENCED_PARAMETER(P)         {(P)=(P);}
#endif





