/****************************************************
 *  File UFSD/include/errors.h
 *  Copyright (C) 2000 Paragon Software,
 *                     Vladislav Erochine
 *
 *  Error codes are listed here.
 ****************************************************/

#ifndef __UFSD_ERRORS
#define __UFSD_ERRORS

#define ERR_NOERROR         0x0000
#define ERR_BADPARAMS       0x0001
#define ERR_BADMEMMNGR      0x0002
#define ERR_BADRWBLOCK      0x0003
#define ERR_BADSTRINGS      0x0004
#define ERR_FSUNKNOWN       0x0006
#define ERR_NOMEMORY        0x0007
#define ERR_BADUFSDFILE     0x0008
#define ERR_OPENROOT        0x0009
#define ERR_OPENFILE        0x000A
#define ERR_CREATEFILE      0x000B
#define ERR_READFILE        0x000C
#define ERR_WRITEFILE       0x000D
#define ERR_NOFILEEXISTS    0x000E
#define ERR_FILEEXISTS      0x000F
#define ERR_NOROOTDIR       0x0010
#define ERR_NOUFSDINIT      0x0011
#define ERR_NOCURRENTDIR    0x0012
#define ERR_BADNAME         0x0013
#define ERR_BADSTRTYPE      0x0014
#define ERR_SMALLBUFFER     0x0015
#define ERR_CLOSEUNABLE     0x0016
#define ERR_NODIRENTRY      0x0017
#define ERR_NOMEMMNGR       0x0018
#define ERR_BADOBJECTTYPE   0x0019
#define ERR_PATHTOOLONG     0x001A
#define ERR_CREATEDIR       0x001B
#define ERR_NOFSINTEGRITY   0x001C
#define ERR_DELOPENFILE     0x001D
#define ERR_DELOPENDIR      0x001E
#define ERR_BADATTRIBUTES   0x001F
#define ERR_WPROTECT        0x0020
#define ERR_DIRNOTEMPTY     0x0021
#define ERR_FILENODATA      0x0022
#define ERR_NOSPC           0x0023  // Not enough free space

#define ERR_LASTKNOWN_ERROR 0x0023

#define ERR_UNKNOWN  (unsigned)0xFFFFFFFF

#endif //__UFSD_ERRORS

