/* Path: hplabs!hpcc01!azarian
   From: azarian@hpcc01.HP.COM (Randy Azarian)
   Newsgroups: comp.sys.ibm.pc.programmer
   Subject: Re: ATI Wonder VGA and 256 colors - a summary
   Message-ID: <13300001@hpcc01.HP.COM>
   Date: 4 May 90 18:35:45 GMT
   Organization: HP Corporate Computing & Services */

#define xsize 27
#define ysize 14

#include <graph.h>                        /* link with GRAPHICS.LIB */
#include <dos.h>

/**********************************************/
/* Display all 64 EGA colors on a VGA display */
/**********************************************/
main()
{
  int i, R,G,B;

  _setvideomode(0x13);                  /* set 256-color mode */


  for (i=0; i<=64; i++) {               /* assign EGA colors to VGA registers */
      if ((i & 32) == 32) R=21; else R=0;
      if ((i & 16) == 16) G=21; else G=0;
      if ((i &  8) ==  8) B=21; else B=0;
      if ((i &  4) ==  4) R+=42;
      if ((i &  2) ==  2) G+=42;
      if ((i &  1) ==  1) B+=42;

      vgacolor(i,R,G,B);
  }

  showcolor(); /* draw 64 boxes, each with a different color */
  getche();    /* pause for user to press a key              */

  _setvideomode(0x3); /* reset video mode for text mode */
}

vgacolor(registr,red,green,blue)
int registr, red, green, blue;
{
  union REGS inreg, outreg;     /*********************************/
  inreg.x.ax = 0x1010;      	/* BIOS function number          */
  inreg.x.bx = registr;     	/* color register number 1-256   */
  inreg.h.dh = red;         	/* red value 0-63                */
  inreg.h.ch = green;       	/* green value 0-63              */
  inreg.h.cl = blue;        	/* blue value 0-63               */
  int86(0x10, &inreg, &outreg); /*********************************/
}

showcolor()
{
  int o, color, x,y;

  for (o=0, y=-4, color=0; o < 8; o++)
    for (x=4, y+=(ysize+7); x < 320; x+=(xsize+13)) {
     _setcolor(247);     _rectangle(_GFILLINTERIOR,x+3,y+3,x+xsize+3,y+ysize+3);
     _setcolor(color++); _rectangle(_GFILLINTERIOR,x,y,x+xsize,y+ysize);
  }
}

