/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strmid
 *
 *  Description :  Copy n characters of a string, begining at a given position
 *		   ( form 1 to ... )
 *
 *  Decisions   :  Stops at the end of input string if given length
 *		   is too big or length = 0.
 *		   If given length or position < 0 returns an empty string.
 *
 *  Parameters  :  out  char  *out_str     result
 *                 in   char  *in_str      in string
 *                 in   int   pos          position where begin to copy
 *                 in   int   length       length to be copied
 *
 *  Return code :   pointer to result.
 *
 *  OS/Compiler :   All
 */

char *strmid( char *out_str, const char	*in_str, int pos, int length )
{

if ( (length < 0) || (pos <= 0)  ) { *out_str = '\0';
				      return(out_str);
				    }

for (; pos; pos -- ) if ( ! *in_str++ ) { *out_str = '\0';
					    return(out_str);
					  }
in_str --;

return( strleft(out_str,in_str,length) );
}
