                /***     Tools for Borland C only   ***/




#ifndef __ToolsIo_H
#define __ToolsIo_H

#include "c2cpp.h"
#include "tools.h"
#include "key.h"


/***
 *  Function    :  listfile
 *
 *  Description :  Display a file on screen with pause
 *    		   after each screen.
 *
 *  Parameters  :  in   char *filename
 *
 *  Decisions   :  If Esc or Ctrl-C is pressed, return immediately
 *
 *  Return code :   0 if OK
 *                 -1 if error
 *                
 *  OS/Compiler :  MS-DOS & Turbo-C
 ***/

EXTERN int listfile( char *filename );



/***
 *  Function    :  border
 *
 *  Description :  Draw double lines border.
 *
 *  Parameters  :  in   int  left, top, right, bottom   border position
 *
 *  Decisions   :  Column range is [1-80]
 *                 Line   range is [1-25]
 *                 If right or bottom = 0, window limit is assumed.
 *
 *  Return code :  none
 *
 *  OS/Compiler :  MS-DOS & Turbo-C
 ***/

EXTERN void border( int left, int top, int right, int bottom );


/***
 *  Function    :   input_date
 *
 *  Description :   Input day, month and year at given position.
 *
 *  Parameters  :   in   int *  day
 *                  in   int *  month
 *                  in   int *  year
 *                  in   int    xpos
 *                  in   int    ypos
 *
 *  Decisions   :   Default = current date
 *		    Century may be omitted.
 *		    Colors = white on blue
 *		
 *  Return      :    0 if OK
 *                  -1 if no input
 *
 *  OS/Compiler :   MS-DOS & Turbo-C
 ***/

EXTERN int input_date( int *day, int *month  , int *year, int xpos, int ypos );



/***
 *  Function    :   input_time
 *
 *  Description :   Input hours and minutes at given position.
 *
 *  Parameters  :   in   int *  hour
 *                  in   int *  min
 *                  in   int *  sec
 *                  in   int    xpos
 *                  in   int    ypos
 *
 *  Decisions   :   Default = current hour and minutes
 *                            if minutes are not given, 0 is assumed
 *		    Colors = white on blue
 *		
 *  Return      :    0 if OK
 *                  -1 if no input
 *
 *  OS/Compiler :   MS-DOS & Turbo-C
 ***/

EXTERN int input_time( int *hour, int *min, int xpos, int ypos );


/***
 *  Function    :   inputs
 *
 *  Description :   Input a string from keyboard
 *
 *  Parameters  :   in/out   char * data        default and result
 *                  in       int    maxLen      maximum length to accept
 *                  in       int    timeout     maximum time (seconds) waiting
 *                                              before a key is pressed
 *
 *
 *  Decisions   :   Valid keys:   Home         Begin of line
 *		                  End          End of line
 *                                Left/Right   One character left/right
 *		                  Insert       Toggle isert on/off
 *                                Delete       Delete current  character
 *                                BackSpace    Delete previous character
 *		                  Ctrl-home    Erase to begin-of-line
 *		                  Ctrl-end     Erase to end-of-line
 *                                Escape       Erase whole input
 *                                Enter        Accept input
 *
 *                  Default string is erase if another input is given.
 *                  (if any non-editing character is hit).
 *		
 *                  If no key is hit before timeout (in seconds)
 *                  the function returns.
 *                  timeout -1 means no timeout.
 *                  timeout  0 means check for type-ahead.
 *
 *  Return      :   length of input
 *
 *  OS/Compiler :   MS-DOS & Turbo-C
 ***/

EXTERN int inputs( char *data, int maxLen, int timeout );



typedef struct { char *title ;
                 char x , y , width , height ;
                 int  index , items , *quickshot ;
                 int cursor ;
                 char buffer[81] ;
                 int  redraw , wait ;
                 char * (*getentry)() ;
                 int    (*match)() ;
               } Menu ;

/***
 *
 *   M_get_item
 *
 *   Returns index of choice
 *           -1 if no key hitten
 *           -2 if none selected (ESC pressed)
 *           -3 if none selected (CTRL_C pressed)
 *
 ***/

EXTERN int M_get_item( Menu *menu );

EXTERN void M_redraw( Menu *menu, int index );


#endif
