/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <dos.h>


/***
 *
 *  Function   :    ungetkey
 *
 *  Topics     :    Puts a 2-bytes key into the keyboard buffer
 *                  (extended characters are added to 256).
 *
 *  Parameters :    in    int key           key to be buffered
 *
 ***/

void ungetkey( int key )

{ unsigned far *kbuf = MK_FP( 0x40, 0x1C );  /* end of keyboard buffer */

  if ( key < 256 )       /*  normal ASCII character  */
     {
       *(unsigned char *)(MK_FP(0x40, *kbuf) ) = (unsigned char) key;
       *(unsigned char *)(MK_FP(0x40, 1 + *kbuf) ) = 0;
     }
  else {                 /*  extended codes: 256 + key  */

         *(unsigned char *)(MK_FP(0x40, *kbuf) ) = 0;
         *(unsigned char *)(MK_FP(0x40, 1 + *kbuf) ) = (unsigned char) (key - 256);
       }

  if ( *kbuf == 0x3C ) *kbuf = 0x1E;
                  else (*kbuf) += 2;
}


/*
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>


void main()
{int r, key = 256 + 60;

ungetkey( key );
ungetkey( 20 );
ungetkey( 40 );

r = -1;
if ( kbhit() ) r = getch();
if ( ! r ) r = getch();

printf( "r = %d\n", r );
}
*/