/*------------------------------------------------------------------------*
 *  File: cal.c								  *
 *  Author: Brady Tippit  1-26-97					  *
 *									  *
 *  A Unix-like calendar utility built using td.lib and Borland keywords. *                                       
 *                                                                        *
 *  To compile, if your turboc.cfg file has -ms in it use:		  *
 *  bcc cal.c td.lib   otherwise use: bcc -ms cal.c td.lib		  *
 *									  *
 *------------------------------------------------------------------------*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "datelib.h"


int main(int argc, char *argv[])
{
   int theYear, theMonth;
   tdtype *date;	       /* Declare a pointer to a tdtype. */
   

   if(argc == 2 && !strcmp(argv[1], "-?"))
   {
     fprintf(stdout, "\nSyntax: cal [month] [year]\n");
     fprintf(stdout, "Usage: prints out the calendar month for\n");
     fprintf(stdout, "any year from Jan 1, 1 A.D. to Dec 31 32766\n");
     fprintf(stdout, "Example: cal 7 1776, or cal 1 1\n");
     fprintf(stdout, "Remember to give the exact year that\n");
     fprintf(stdout, "you want. Don't abbreviate!\n");
     fprintf(stdout, "For the current month, just type cal.\n");
     return(1);
   }
   else
    if(argc != 1 && argc != 3)
    {
      fprintf(stderr, "\nCal requires 0 or 2 arguments\n");
      fprintf(stdout, "For help type  cal -?\n");
      return(1);
    }
    if(argc == 1)
    {
      date = TimeDate();	 /* Initialize and fill all fields.   */
      theMonth = date->td_mon;	 /* Access the month and year fields. */
      theYear = date->td_year;
    }
    else
     if(argc == 3)
     {
       theMonth = atoi(argv[1]);
       theYear  = atoi(argv[2]);
     }

     PrintCalendar(theMonth, theYear);
  
   return(0);
}
       