/* ----------------------------------------------------------- *\

   TEST.C      version 1.10b
   (c) Copyright 1994 Heng Yuan.

   You are granted to modify this file any way you wish.
   This code is provided "AS IS", without any warranty.

   This is a demo of ACA Bin2Obj 1.10b.  The beauty of linking
   graphics and text files into the executable is that there
   are absolutely no need to write codes to find these files
   and read them in at run time.  This also makes the finished
   product look more compact.

   Since this program is just a demonstration, lots of codes
   in this program are directly copied from the Borland C++
   help file which is very good at this.

\* ----------------------------------------------------------- */

#include <alloc.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>

/* include text file */
extern unsigned char IntroText[];
/* include intro picture */
extern unsigned char IntroPict[];

/* ----------------------------------- *\
  this code is used to detect VGA
  adapter.  Copied from help file
  with slight modifications
\* ----------------------------------- */
int huge detectVGA (void)
{
  int driver, mode, sugmode = 0;

  detectgraph (&driver, &mode);
  if (driver == VGA)
    /* return suggested video mode number */
    return sugmode;
  else
    /* return an error code */
    return grError;
}

/* ----------------------------------- *\
  this code is used to detect VGA
  adapter.  No modifications
\* ----------------------------------- */
/* check for and report any graphics errors */
void checkerrors (void)
{
  int errorcode;

  /* read result of last graphics operation */
  errorcode = graphresult();
  if (errorcode != grOk)
    {
      printf ("Graphics error: %s\n", grapherrormsg (errorcode));
      printf ("Press any key to halt:");
      getch ();
      exit (1);
    }
}

void main ()
{
  int  gdriver = 0, gmode = 0;

  /*
    To display a graphics file, the video mode must be switched to
    graphics.  The graphics file used in this example requires 256
    color, so the most portable mode is 320x200x256c using VGA256.BGI.
    The setup is according to the Borland Help file examples.
  */
  /* install a user written device driver */
  gdriver = installuserdriver("SVGA256", detectVGA);
  /* must force use of detection routine */
  gdriver = DETECT;
  /* check for any installation errors */
  checkerrors();
  /* initialize graphics and local variables */
  initgraph(&gdriver, &gmode, "");

  /*
     The bitmap image was originally created using NeoPaint
     and saved in .PCX file extension.  Then used MVPPAINT
     to convert the .PCX to .VGA.  The file was then inserted
     into .OBJ.  Note that SVGA256.BGI is used instead of
     VGA256.BGI.  This is because MVPPAINT VGA format is
     compatible with SVGA256.BGI.  The image data format of
     VGA256.BGI is slightly different from SVGA256.BGI.
     BTW, SVGA256.BGI can also be used to display mode 0x13.
  */
  putimage (0, 0, IntroPict, COPY_PUT);

  getch ();

  closegraph ();

  /*
     Since dos text files have LF and CR as goto the first column of a
     new line, and because most C string only have LF as the return,
     Borland C lib automatically adds CR before each LF.  And since dos
     editors all add CR before LF, the result is there are two CR before
     every LF are actually written on screen.  You won't discover that
     there are two CR unless the the output has been redirected to a text
     file and viewed through a text file viewer such as the famous LIST,
     the text file looks double spaced. This is because CR in dos is
     interpreted as placing the cursor to the first column.  Yet many
     text file viewers simply take CR as the carriage return and do not
     actually process LF.  Thus the redirected text file looks double
     spaced.  For the best result, one can take a utility that striple
     CR out of the text file.

     Another reminder, the text file needs to be ended with character
     \x00 so that puts or printf can understand when to stop putting
     characters on screen.

     The text file was created using the DOS EDIT.
  */
  puts (IntroText);
}
