/* x.h                    freeware                  xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void eqTan(
double a)
{
 printf(" %0.3lf*x %+0.3lf", Df(a), (-Df(a)* a + f(a)));
 printf(" = 0");
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltS_Tan(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double a,
  char      feq[TXT_EQ],
  char     Dfeq[TXT_EQ]
)
{
FILE   *fp;

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",feq);
fprintf(fp,", ");
fprintf(fp," %0.3lf*x %+0.3lf", Df(a), (-Df(a)* a + f(a)));
fprintf(fp,"\n\n");
fprintf(fp," reset");

 fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltA_Tan(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double amin,
double amax,
double astep,
  char      feq[TXT_EQ],
  char     Dfeq[TXT_EQ]
)
{
double a;
FILE   *fp;

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");

for(a = amin; a<amax; a +=astep)
{
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",feq);
fprintf(fp,", ");
fprintf(fp," %0.3lf*x %+0.3lf", Df(a), (-Df(a)* a + f(a)));

fprintf(fp,"\n pause 1\n\n");
}

fprintf(fp," reset");

 fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnplt_Tan_xy(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double a,
  char   feq[TXT_EQ],
  char  Dfeq[TXT_EQ]
)
{
char    FPa[FILENAME] = "P";
char    FA[FILENAME] = "A";
char    FB[FILENAME] = "B";
FILE   *fp;
FILE   *fq;
FILE   *fr;
FILE   *fs;

        fp = fopen("f_Df.plt","w");
        fq = fopen(   FPa,"w");
        fr = fopen(   FA,"w");
        fs = fopen(   FB,"w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis \n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",feq);
fprintf(fp,", ");
fprintf(fp," %0.3lf*x %+0.3lf", Df(a), (-Df(a)* a + f(a)));

fprintf(fp,", ");
fprintf(fp," \"%s\" lt 1 ",FPa);
fprintf(fp,", ");
fprintf(fp," \"%s\" lt 1 ",FA);
fprintf(fp,", ");
fprintf(fp," \"%s\" lt 1 ",FB);
fprintf(fp,"\n\n");
fprintf(fp," reset");

fprintf(fq," %0.3lf   %0.3lf", a, f(a));
fprintf(fr," %0.3lf   %0.3lf", a-(f(a)/Df(a)), 0.);
fprintf(fs," %0.3lf   %0.3lf", 0., f(a)-(Df(a)*a));

 fclose(fp);
 fclose(fq);
 fclose(fr);
 fclose(fs);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnplt_TanPx(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double a,
  char   feq[TXT_EQ],
  char  Dfeq[TXT_EQ]
)
{
char    FPX[FILENAME] = "Ptoxaxis";
FILE   *fp;
FILE   *ft;

        fp = fopen("f_Df.plt","w");
        ft = fopen(FPX,  "w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis \n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",feq);
fprintf(fp,", ");
fprintf(fp," %0.3lf*x %+0.3lf", Df(a), (-Df(a)* a + f(a)));
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 ",FPX);
fprintf(fp,"\n\n");
fprintf(fp," reset");

fprintf(ft," %0.3lf   %0.3lf\n",  a, f(a));
fprintf(ft," %0.3lf   %0.3lf", a-(f(a)/Df(a)), 0.);

 fclose(fp);
 fclose(ft);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnplt_TanPy(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double a,
  char   feq[TXT_EQ],
  char  Dfeq[TXT_EQ]
)
{
char    FPY[FILENAME]  = "Ptoyaxis";
FILE   *fp;
FILE   *ft;

        fp = fopen("f_Df.plt","w");
        ft = fopen(FPY,  "w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",feq);
fprintf(fp,", ");
fprintf(fp," %0.3lf*x %+0.3lf", Df(a), (-Df(a)* a + f(a)));
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 ",FPY);
fprintf(fp,"\n\n");
fprintf(fp," reset");

fprintf(ft," %0.3lf   %0.3lf\n", a,          f(a));
fprintf(ft," %0.3lf   %0.3lf", 0., f(a)-(Df(a)*a));

 fclose(fp);
 fclose(ft);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnplt_TanxM(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double a,
  char   feq[TXT_EQ],
  char  Dfeq[TXT_EQ] 
)
{
char    FPX[FILENAME] = "PX";
char    FAM[FILENAME] = "AM";
FILE   *fp;
FILE   *ft;
FILE   *fr;

        fp = fopen("f_Df.plt","w");
        ft = fopen(FPX,  "w");
        fr = fopen(FAM,  "w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis \n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",feq);
fprintf(fp,", ");
fprintf(fp," %0.3lf*x %+0.3lf", Df(a), (-Df(a)* a + f(a)));
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 ",FPX);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 4 ",FAM);
fprintf(fp,"\n\n");
fprintf(fp," reset");

fprintf(ft," %0.3lf   %0.3lf\n",  a, f(a));
fprintf(ft," %0.3lf   %0.3lf", a-(f(a)/Df(a)), 0.);

fprintf(fr," %0.3lf   %0.3lf\n",  a-(f(a)/Df(a)), 0.);
/*fprintf(fr," %0.3lf   %0.3lf  ", (a-(f(a)/Df(a)))+(f(a)/Df(a)), 0.);*/
fprintf(fr," %0.3lf   %0.3lf  ",    a,                            0.);

 fclose(fp);
 fclose(ft);
 fclose(fr);
}
