/*         .c                       freeware                   xhunga@tiscali.fr
*/
/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
        return(x*x  - 5.0);
}
char  feq[] = "x**2 - 5.0";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
       return( 2.0*x);
}
char Dfeq[] = "2.0*x";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*P_f)     (double x);
double (*PDf)(double x);

   int                  n = 6;
double                  a = 5.0;
double FirstApproximation = 2.5;
/*-------------------------------- PROGRAM ---------------------------------- */
 P_f      =  f;
 PDf = Df;

 clrscrn();
 printf(" Use Newton's method to approximate sqrt(%.1lf).       \n\n",a);
 printf(" This is equivalent to find the positive real root of :\n\n");
 printf(" f : x-> %s\n\n", feq);
                       /* plot [xmin:xmax] [ymin:ymax] */
       gplt_f(-3,      /* xmin  */
               3,      /* xmax  */
              -6,      /* ymin  */
               2,      /* ymax  */
               feq
              );

 printf(" To see the graph of f, open the file \"f_Df.plt\" with Gnuplot.\n\n");
 printf(" You can see that, the positive real root\n");
 printf(" of f is between 2.0 and 3.0.\n\n");
 printf(" Choose x = %.1lf as a first approximation.\n\n",FirstApproximation);
 getchar();

 clrscrn();
 printf(" As a first approximation x = %.1lf \n\n",FirstApproximation);
 printf(" The Newton's method give :                \n\n");
 p_Newton_s_Method(FirstApproximation,
                   n,
           (*P_f),
           (*PDf));
 getchar();

 clrscrn();
 printf(" The Newton's method give :                \n\n");
 printf("         x = %.15lf\n\n",
          Newton_s_Method(FirstApproximation,
                                           n,
                                   (*P_f),
                                   (*PDf)));
 printf(" The function sqrt(%.1lf) :                \n\n",a);
 printf("         x = %.15lf\n\n",sqrt(a));

 printf("\n Press return to continue");
 getchar();

 return 0;
}

