/*         .c                       freeware                   xhunga@tiscali.fr
*/
/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"
#include "f2m.h"
#include "g2m.h"

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*Pfunct)     (double x);
double (*PfunctDeriv)(double x);

int                     n =  6;

double                  r =  0.0;
double                  s =  2.0;
double FirstApproximation =  1;
double                c;
/*-------------------------------- PROGRAM ---------------------------------- */
 clrscrn();

 printf(" f : x-> %s\n\n\n", feq);

 printf(" The function f is continuous on [%.0lf,%.0lf], \n", r,s);
 printf(" and differentiable on (%.0lf,%.0lf)            \n\n\n", r,s);

 printf(" Hence by the mean value theorem, there is a\n");
 printf(" number c in (%.0lf,%.0lf) such that        \n\n\n", r,s);

 printf("       Df(c) = (f(s)-f(r))/(s-r) \n\n\n");

 printf(" With r = %.0lf, and s = %.0lf we have : \n\n", r, s);
 printf("         Df(c)         = (f(s)-f(r))/(s-r) \n\n");
 printf("         %s        = %0.3lf \n\n",
         Dfeq , (f(s)-f(r))/(s-r));
 printf("      or %s %+0.3lf = 0 (simplify/copy into gxx.h)\n\n",
         Dfeq ,-(f(s)-f(r))/(s-r));
 printf(" Name this equation  g : x-> %s \n", geq);
 getchar();


 clrscrn();
 printf(" Use Newton's method to approximate a real root\n\n");
 printf(" of g in the interval (%.0lf,%.0lf)\n\n\n", r,s);

 printf(" g : x-> %s\n\n\n", geq);
                       /* plot [xmin:xmax] [ymin:ymax] */
       gplt_f(-3,      /* xmin  */
               3,      /* xmax  */
              -2,      /* ymin  */
               1,      /* ymax  */
               geq
              );
 printf(" To see the graph of g, open the file \"f_Df.plt\" with Gnuplot.\n\n\n");
 printf(" You can see that, the real root of g in the\n");
 printf("  interval (%.0lf,%.0lf) is between 1.0 and 2.0.\n\n\n", r,s);

 printf(" Choose c = %.1lf as a first approximation.\n\n",FirstApproximation);
 getchar();

 clrscrn();
 printf(" As a first approximation c = %.1lf \n\n",FirstApproximation);
 printf(" The Newton's method give :                \n\n");
 Pfunct      =  g;
 PfunctDeriv = Dg;
 p_Newton_s_Method(FirstApproximation,
                   n,
           (*Pfunct),
           (*PfunctDeriv));

  c = Newton_s_Method(FirstApproximation,
                        n,
                (*Pfunct),
           (*PfunctDeriv));
 getchar();

 clrscrn();
 Pfunct      =  f;
 PfunctDeriv = Df;
 printf(" With c = %0.3lf, the equation of the tangent is :\n\n",c);
 printf("       Df(c) (x-c) + f(c) = ");
 eq_Tan(  c,
       (*Pfunct),
       (*PfunctDeriv)
       );
 printf("\n\n");

                         /* plot [xmin:xmax] [ymin:ymax] */
gplt_TMeanValue(-1,      /* xmin */
                 3,      /* xmax */
              -1.0,      /* ymin */
               2.0,      /* ymax */
                 r,
                 s,
                 c,
               feq,
         (*Pfunct),
         (*PfunctDeriv)
               );

 printf(" This tangent is parallel to the secant line (rs):\n\n");
 printf("\n\n\n");
 printf(" To see the graph of f, open the file \"f_Df.plt\" with Gnuplot.\n\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

