/* This program splits the input file into smaller files. 

   USAGE: CHOP FILENAME SIZE -SWITCHES
   Version 1.1.  Written by W. J. Kennamer and released into the public domain.
     FILENAME is any valid MS-DOS filename.  Wildcards are not supported.
     Output file names will be FILENAME.1, FILENAME.2, etc.
     Output files are always terminated with a carriage return and a <ctrl>Z.
     SIZE is the desired file size for each new file.
     SWITCHES must follow both the FILENAME and SIZE parameters,
       and may be entered in any order.  Switches may be combined.
     Valid SWITCHES are:
       -s  strict     chop file at exact SIZE boundary.
       -r  return     chop file at first carriage return
                        following SIZE characters (default).
       -px partition  partition file into x equal units.
                         SIZE is ignored (and may be omitted) if
                         you choose this option.

File pointer fp1 is the input file.  fp2 is always the output 
   file, though its name changes as new output files are
   opened.

*/   

#include "stdio.h"
#include "ctype.h"

#define VERSION "1.2"
#define PROGNAME "CHOP"
#define CTRL_Z   0x1a
#define VOID     int
#define CR       0x0d
#define OFF   0
#define ON   1

main(argc,argv)
int argc;
char *argv[];
   {
	VOID help();
	VOID close_out();

   int c;                             /* current character                */
   int num_output_files = 0;          /* no of files successfully created */
   int count;                         /* no. of digits in size            */
   int length;                        /* length of matching string        */
   int normal = ON;                   /* normal CR breaks                 */
   int strict = OFF;                  /* break exactly at boundary        */
   int partition = OFF;               /* strict or normal                 */
   int num_part;                      /* number of partitions             */
   int int_size;                      /* integer for file size            */

   long i;                            /* counts bytes in output file      */
   long size = 0;                     /* partition value -- file size     */
   long byte_count = 0;               /* total bytes in original file     */
   long inp_file_size = 0;            /* total bytes in original file     */
   long out_file_size = 0;            /* total bytes in output file       */
 
   FILE *fp1,*fp2;                    /* fp1=input, fp2=output            */

   char *p;                           /* pointer to switch string         */
   char *period_p;                    /* location of period in filename   */
   char *output_file;                 /* output file name                 */
   char filename[15];                 /* original file name               */ 
   char *stpchr();                    /* substring match function (MS)    */
   char line1[15];                    /* data buffer                      */
   char line2[15];                    /* data buffer                      */
   char *switches;                    /* string to hold switches          */

   if( argc > 4 || argc < 2 || *argv[3] == "-?" )
      {
      help();
      exit(1);
      }

   /* see which argument is the switch */
   if( (length = stcpma(argv[2],"-")) != 0)
      {
      switches = line2;
      strcpy(switches,argv[2]);
      }
   else if( (length = stcpma(argv[3],"-")) != 0)
      {
      switches = line2;
      strcpy(switches,argv[3]);
      }

   for( p = switches ; (p - switches) < strlen(switches)  ; p++ )
      {
      if( *p == 's' )
         {
         strict = ON;
         normal = OFF;
         }
      else if ( *p == 'r' || *p == 'n')
         {
         normal = ON;  
         strict = OFF;
         }
      else if ( *p == 'p')
         {
         partition = ON;  
         if(stcd_i((p+1),&num_part) == 0)
            {
            printf("Invalid number of partitions.\n");
            exit(1);
            }
         }
      }

   if( (fp1 = fopen(argv[1],"r") ) == NULL)
      {
      printf("Cannot open %s for input.\n",argv[1]);
      exit(1);
      }

   /* determine file size */
   if(partition == ON)
      {

      if( fseek(fp1,0L,2) == -1)            /* position at EOF */
         {
         printf("Error seeking end of input file.\n");
         exit(1);
         }
      
      inp_file_size = ftell(fp1);         /* tell EOF  */

		/* each partition requires 3 extra bytes -- CTRL_Z, newline */
      size = ((inp_file_size + 3*(long)num_part) / (long)num_part ) + 1 ;

      printf("  Input file size = %ld bytes\n",inp_file_size);
      printf("   Partition size = %ld bytes\n",size);
      printf("No. of partitions = %ld\n\n",(long)num_part);

      rewind(fp1);                     /* back to beginning of file */      
      }
   else                                 /* partition is not ON */
      {                                 /* read SIZE from command line */

      count = stcd_i(argv[2],&int_size);  /* convert string to integer */
      if(count == 0)
         {
         printf("Invalid size\n");
         exit(1);
         }
      size = (long)int_size;         /* convert to long */
      }

   strcpy(&filename,argv[1]);

   period_p = stpchr(&filename,'.');         /* locate the period, if any */

   if( period_p != NULL )
      *period_p = '\0';                     /* chop off the period  */

   while ( (c = getc(fp1)) != EOF)   
      {
      ungetc(c,fp1);      

      (num_output_files)++;                 
      if(num_output_files > 127)
         {
         printf("Too many files--%d.\nExiting program\n.",num_output_files);
         exit(1);
         }

      output_file = line1;                /* initialize output_file pointer */

      /* create the next filename */
      sprintf(output_file,"%s.%-d",filename,num_output_files);

      if( (fp2 = fopen(output_file,"w")) == NULL)
         {
         printf("Cannot open %s for output\n",output_file);
         printf("Exiting the program.\n");
         printf("%d files created.\n",(num_output_files) - 1 );
         printf("Actual original filesize = %u bytes.\n",byte_count);
         exit(1);
         }

      for( i = 0 ; i < (size - 3) ; i++ )      /* output until size reached */
         {                                    /* leave 3 spaces for newline, CTRL Z */
         c = getc(fp1);

         if( c == '\n')
            {
            byte_count += 2;                  /* newline counts as 2 bytes */
            i++;
            }
         else
            byte_count++;

         if( c == EOF )
            {
            close_out(fp2,output_file);
            exit(0);
            }
         putc(c,fp2);
         }

      if( normal == ON )
         {
         while( (c = getc(fp1)) != '\n' )   
            {
            if( c == EOF )
               {
               close_out(fp2,output_file);
               exit(0);
               }
            putc(c,fp2);
            byte_count++;
            }
         byte_count += 2;            /* count the newline (2 bytes) */
         }   

      close_out(fp2,output_file);
      }                           /* end while not eof */
   }                              /* end of main()   */

/***************************************************************************/
VOID help()
   {
   printf("Version %s -- 02/26/85\n",VERSION);
   printf("USAGE: %s FILENAME SIZE -SWITCHES\n\n",PROGNAME); 
	printf("Written by W. J. Kennamer (74025,514) and released into the public domain.\n");
   printf("  FILENAME is any valid MS-DOS filename.  Wildcards are not supported.\n");
   printf("  Output file names will be FILENAME.1, FILENAME.2, etc.\n");
   printf("  Output files are always terminated with a carriage return and a <ctrl>Z.\n");
   printf("  SIZE is the desired file size for each new file.\n");
   printf("  SWITCHES must follow both the FILENAME and SIZE parameters,\n");
   printf("    and may be entered in any order.  Switches may be combined.\n");
   printf("  Valid SWITCHES are:\n");
	printf("ͻ\n");
   printf("   -s  strict     chop file at exact SIZE boundary.             \n");
	printf("Ķ\n");
   printf("   -r  return     chop file at first carriage return            \n");
   printf("                    following SIZE characters (default).        \n");
	printf("Ķ\n");
   printf("   -px partition  partition file into x equal units.            \n");
   printf("                    SIZE is ignored (and may be omitted) if     \n");
   printf("                    you choose this option.                     \n");
	printf("ͼ\n");
   }

/***************************************************************************/

VOID close_out(fp,filename)

FILE *fp;
char *filename;                    /* output file name                 */

   {
   long file_size;

   putc('\n',fp);						/* terminating newline */
   putc(CTRL_Z,fp);                /* terminate file with EOF mark    */
   if( fseek(fp,0L,2) == -1 )         /* position at EOF                 */
		{
		printf("Error seeking end of output file.\n");                
		exit(1);
		}
   file_size = ftell(fp);          /* report EOF position             */
   fclose(fp);
   printf("Created %s -- %ld bytes\n" , filename , file_size);
   }

/***************************************************************************/
                                                                                                                                                                                                                                                                                                                                                             