/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1996, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and sources are distributed along with any executables derived from them.
 *
 * The author is not responsible for damages, either direct or consequential,
 * that may arise from use of this software.
 *
 * v1.85 July 2000
 * David Lindauer, gclind01@starbase.spd.louisville.edu
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
/*
 * iexpr.h
 *
 * ICODE structures
 */

#define F_ADDR 1
#define F_NOVALUE 2
#define F_VOL 4

/* icode innstruction opcodes */
enum i_ops { i_line, i_passthrough,
	i_label, i_goto, i_gosub, i_trap, i_int,i_ret, i_rett,
	i_add, i_sub, i_udiv, i_umod, i_sdiv, i_smod, i_umul, i_smul,
	i_lsl, i_lsr, i_asl, i_asr,
	i_and, i_or, i_eor, i_setnz, 
	i_neg, i_not,
	i_assn, i_genword, i_coswitch, i_dc, i_assnblock,
	i_jc,i_ja,i_je,i_jnc,i_jbe,i_jne,i_jl,i_jg,i_jle,i_jge,
	i_parm, i_parmadj, i_parmblock, i_cppini, i_block, i_livein,
	i_icon, i_fcon
};

/* icode address modes annd special regs */
enum i_adr { i_none, i_immed, i_direct,	i_ind, i_bf, 
/* special named nodes come AFTER rsp for no bugs */
		i_rsp, i_rret, i_rlink,
		i_rstruct, i_rstructstar };
/*
 * structure for startup/rundown records (used in #pragma ) 
 */
typedef struct _startup {
	struct _startup *link;
	char *name;	/* name */
	int val;	/* prio */
} STARTUP;

/*
 * address mode
 */
typedef struct {
        enum i_adr      mode;     	/* mode */
	char 		size;		/* size */
	char		startbit,bits;	/* bit width  for i_Bf*/
	char		ptrref;		/* TRUE if is a ref through a pointer */
	char 		arrayref;	/* true if is an array reference */
	char 		vol;		/* TRUE if is a node for a volatile var */
        struct enode    *offset;	/* offset */
} IMODE;

#define IM_LIVELEFT 1
#define IM_LIVERIGHT 2
/*
 * icode node
 * this is also used for dag nodes
 */
typedef struct quad {
	struct _basic_dag {
		enum i_ops opcode;	/* opcode */
		IMODE *left;	/* ans = left opcode right */
			/* for a i_label node, left is the label nnumber cast
			 * to a imode* */
		IMODE *right;
		struct ival {		/* values for constant nodes */
			long i;
			double f;
		} v;
		long	label;	/* aux values used by i_coswitch */
	} dc;
	char	livein;
	struct quad *fwd, *back;	/* linnkages */
	IMODE *ans;
} QUAD;

#define DAGCOMPARE sizeof(_basic_dag)
#define DAGSIZE 1024

#include "iexpr.p"	